# إعدادات الدرافت في SAP B1

تم إصلاح مشكلة إرسال الدرافت إلى SAP. الآن يتم إرسال الدرافت كـ Sales Order بدلاً من Quotation مع إضافة معرفات خاصة.

## متغيرات البيئة المطلوبة في .env

```env
# إعدادات SAP الأساسية
SAP_ENABLED=true
SAP_BASE_URL=https://your-sap-server:50000/b1s/v1
SAP_USERNAME=your_username
SAP_PASSWORD=your_password
SAP_COMPANY_DB=your_database

# إعدادات المزامنة التلقائية
SAP_AUTO_SYNC_SALES=true
SAP_AUTO_SYNC_QUOTATIONS=true
SAP_AUTO_SYNC_DRAFTS=true

# إعدادات الدرافت الجديدة
SAP_DRAFT_AS_SALES_ORDER=true
SAP_DRAFT_DOC_STATUS=bost_Open
SAP_DRAFT_COMMENT_PREFIX="DRAFT SALES ORDER"
```

## التغييرات المطبقة

1. **تغيير Endpoint**: الدرافت الآن يُرسل إلى `Orders` بدلاً من `Quotations`
2. **حالة المستند**: يتم تعيين `DocStatus = bost_Open` للدرافت
3. **نوع المستند**: `DocType = dDocument_Items`
4. **التعليقات**: إضافة تعليق "DRAFT SALES ORDER" للتمييز
5. **نوع قاعدة البيانات**: تغيير من `draft` إلى `draft_order`

## كيفية التحقق من عمل الإصلاح

1. أنشئ درافت جديد من POS
2. تحقق من اللوجز للتأكد من إرسال الدرافت كـ Sales Order
3. ادخل على SAP وتحقق من وجود Sales Order مع التعليق المناسب
4. جرب تحديث الدرافت والتأكد من عمل التحديث

## الأخطاء المحتملة

- إذا لم يظهر الدرافت في SAP، تحقق من إعدادات `SAP_AUTO_SYNC_DRAFTS=true`
- إذا ظهر كـ Quotation بدلاً من Sales Order، تحقق من `SAP_DRAFT_AS_SALES_ORDER=true`
- إذا لم تظهر التعليقات، تحقق من `SAP_DRAFT_COMMENT_PREFIX` 