<?php
namespace App;

use Illuminate\Database\Eloquent\Model;

class SapUomMapping extends Model
{
    protected $fillable = [
        'uom_group_entry', 
        'uom_code', 
        'uom_name', 
        'uom_entry',
        'uom_type',
        'is_base_uom',
        'conversion_rate',
        'unit_id'
    ];
    
    protected $casts = [
        'is_base_uom' => 'boolean',
        'conversion_rate' => 'decimal:4',
    ];
    
    public function unit()
    {
        return $this->belongsTo(Unit::class, 'unit_id');
    }
    
    /**
     * Get display name with conversion rate
     */
    public function getDisplayNameAttribute()
    {
        $name = $this->uom_name ?: $this->uom_code;
        
        if ($this->conversion_rate && $this->conversion_rate != 1) {
            $name .= " ({$this->conversion_rate}:1)";
        }
        
        if ($this->is_base_uom) {
            $name .= " [Base]";
        }
        
        return $name;
    }
    
    /**
     * Check if mapped to local unit
     */
    public function getIsMappedAttribute()
    {
        return !is_null($this->unit_id);
    }
    
    /**
     * Get products using this UoM
     */
    public function products()
    {
        return Product::where('sap_uom_group_entry', $this->uom_group_entry)
            ->where(function($query) {
                $query->where('sap_inventory_uom', $this->uom_code)
                    ->orWhere('sap_inventory_uom', $this->uom_entry);
            });
    }
}