<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SapWarehouseMapping extends Model
{
    protected $fillable = ['warehouse_code', 'warehouse_name', 'location_id'];
    
    public function location()
    {
        return $this->belongsTo(BusinessLocation::class, 'location_id');
    }
    
    /**
     * Get warehouse stock summary
     */
    public function getStockSummaryAttribute()
    {
        $summary = SapProductWarehouse::where('warehouse_code', $this->warehouse_code)
            ->selectRaw('COUNT(DISTINCT sap_item_code) as product_count')
            ->selectRaw('SUM(in_stock) as total_stock')
            ->selectRaw('SUM(committed) as total_committed')
            ->selectRaw('SUM(ordered) as total_ordered')
            ->first();
            
        return [
            'product_count' => $summary->product_count ?? 0,
            'total_stock' => $summary->total_stock ?? 0,
            'total_committed' => $summary->total_committed ?? 0,
            'total_ordered' => $summary->total_ordered ?? 0,
            'total_available' => ($summary->total_stock ?? 0) - ($summary->total_committed ?? 0)
        ];
    }
    
    /**
     * Get display name
     */
    public function getDisplayNameAttribute()
    {
        $name = $this->warehouse_name ?: $this->warehouse_code;
        
        if ($this->location) {
            $name .= " → " . $this->location->name;
        }
        
        return $name;
    }
    
    /**
     * Check if mapped to location
     */
    public function getIsMappedAttribute()
    {
        return !is_null($this->location_id);
    }
}