<?php

return [
    /*
    |--------------------------------------------------------------------------
    | SAP B1 Integration Settings
    |--------------------------------------------------------------------------
    |
    | This file contains the configuration settings for connecting to
    | SAP Business One Service Layer API.
    |
    */

    'enabled' => env('SAP_ENABLED', false),
    
    'base_url' => env('SAP_BASE_URL', 'https://server:50000/b1s/v1'),
    'username' => env('SAP_USERNAME', 'manager'),
    'password' => env('SAP_PASSWORD', 'password'),
    'company_db' => env('SAP_COMPANY_DB', 'SBO_DB'),
    'auto_sync_contacts' => env('SAP_AUTO_SYNC_CONTACTS', true),
    'sync_contact_immediately' => env('SAP_SYNC_CONTACT_IMMEDIATELY', true),
    'use_sap_card_code_as_contact_id' => env('SAP_USE_CARD_CODE_AS_CONTACT_ID', true),
    




    'auto_sync_sales' => env('SAP_AUTO_SYNC_SALES', true),
    'auto_sync_quotations' => env('SAP_AUTO_SYNC_QUOTATIONS', true),
    'auto_sync_drafts' => env('SAP_AUTO_SYNC_DRAFTS', true),
    
    // Draft-specific settings
    'draft_as_sales_order' => env('SAP_DRAFT_AS_SALES_ORDER', true), // Send drafts as sales orders
    'draft_doc_status' => env('SAP_DRAFT_DOC_STATUS', 'bost_Open'), // SAP document status for drafts
    'draft_comment_prefix' => env('SAP_DRAFT_COMMENT_PREFIX', 'DRAFT SALES ORDER'), // Comment prefix for drafts
    
    /*
    |--------------------------------------------------------------------------
    | Queue Settings
    |--------------------------------------------------------------------------
    |
    | Configure job queue settings for SAP synchronization.
    |
    */
    'use_queue' => env('SAP_USE_QUEUE', true),
    'queue_name' => env('SAP_QUEUE_NAME', 'sap-sync'),

    
];