<?php
// إنشاء ملف config/whatsapp.php

return [
    
    /*
    |--------------------------------------------------------------------------
    | UltraMsg Configuration
    |--------------------------------------------------------------------------
    |
    | This configuration is for UltraMsg WhatsApp API integration
    |
    */
    
    'ultramsg' => [
        'instance_id' => env('ULTRAMSG_INSTANCE_ID', '26795'),
        'token' => env('ULTRAMSG_TOKEN'),
        'base_url' => env('ULTRAMSG_BASE_URL', 'https://api.ultramsg.com'),
        'timeout' => [
            'default' => env('WHATSAPP_DEFAULT_MESSAGE_TIMEOUT', 30),
            'image' => env('WHATSAPP_IMAGE_TIMEOUT', 120),
        ],
        'limits' => [
            'max_image_size' => env('WHATSAPP_MAX_IMAGE_SIZE', 5242880), // 5MB
        ]
    ],
    
    /*
    |--------------------------------------------------------------------------
    | Company Information
    |--------------------------------------------------------------------------
    |
    | Default company information for quotes and messages
    |
    */
    
    'company' => [
        'name' => env('COMPANY_NAME', 'COMBO SAS'),
        'phone' => env('COMPANY_PHONE', '+964xxxxxxxxx'),
        'email' => env('COMPANY_EMAIL', 'info@combosas.com'),
        'address' => env('COMPANY_ADDRESS', 'العراق - بغداد'),
        'website' => env('COMPANY_WEBSITE', 'https://combosas.com'),
    ],
    
    /*
    |--------------------------------------------------------------------------
    | Quote Settings
    |--------------------------------------------------------------------------
    |
    | Settings for generating and sending quotes
    |
    */
    
    'quote' => [
        'validity_days' => env('WHATSAPP_QUOTE_VALIDITY_DAYS', 30),
        'default_currency' => 'IQD',
        'exchange_rates' => [
            'USD_TO_IQD' => 1300,
        ],
        'templates' => [
            'text_header' => "🏢 {company_name}\n📋 عرض السعر رقم: {quote_number}\n📅 التاريخ: {quote_date}\n👤 العميل: {customer_name}\n" . str_repeat('=', 40) . "\n\n",
            'text_footer' => "\n" . str_repeat('=', 40) . "\n✅ العرض صالح لمدة {validity_days} يوماً\n📧 للاستفسار: {company_email}",
            'image_caption' => 'عرض السعر من {company_name} - العميل: {customer_name}',
        ]
    ],
    
    /*
    |--------------------------------------------------------------------------
    | Message Templates
    |--------------------------------------------------------------------------
    |
    | Pre-defined message templates
    |
    */
    
    'templates' => [
        'greeting' => 'مرحباً {customer_name}،\n\nيسعدنا تقديم عرض السعر لكم.',
        'closing' => 'شكراً لكم\nفريق {company_name}',
        'test_message' => 'اختبار اتصال من نظام POS - {timestamp}',
    ],
    
    /*
    |--------------------------------------------------------------------------
    | Error Messages
    |--------------------------------------------------------------------------
    |
    | Custom error messages in Arabic
    |
    */
    
    'messages' => [
        'errors' => [
            'invalid_phone' => 'رقم الهاتف غير صحيح',
            'instance_not_connected' => 'Instance غير متصل',
            'token_invalid' => 'Token غير صحيح',
            'rate_limit' => 'تجاوزت الحد المسموح من الرسائل',
            'image_too_large' => 'حجم الصورة كبير جداً',
            'network_error' => 'خطأ في الشبكة',
        ],
        'success' => [
            'message_sent' => 'تم إرسال الرسالة بنجاح',
            'quote_sent' => 'تم إرسال عرض السعر بنجاح',
            'connection_test' => 'تم اختبار الاتصال بنجاح',
        ]
    ],
    
    /*
    |--------------------------------------------------------------------------
    | Logging
    |--------------------------------------------------------------------------
    |
    | Enable/disable logging for WhatsApp operations
    |
    */
    
    'logging' => [
        'enabled' => env('WHATSAPP_LOGGING_ENABLED', true),
        'level' => env('WHATSAPP_LOG_LEVEL', 'info'),
        'channel' => env('WHATSAPP_LOG_CHANNEL', 'single'),
    ]
    
];