<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('transaction_sell_lines', function (Blueprint $table) {
            $table->string('warehouse_code', 10)->nullable()->after('secondary_unit_quantity')->comment('Warehouse code like W01, W02, etc.');
            $table->string('warehouse_id', 50)->nullable()->after('warehouse_code')->comment('Warehouse identifier for SAP integration');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('transaction_sell_lines', function (Blueprint $table) {
            $table->dropColumn(['warehouse_code', 'warehouse_id']);
        });
    }
}; 