# Table Designer Tool for POS System

## Overview

The Table Designer tool allows users to customize the appearance and functionality of tables in the POS interface. Users can:

- **Reorder columns** via drag and drop
- **Show/hide specific columns**
- **Rename column headers** (display names)
- **Customize styles** (font size, colors, etc.)
- **Save preferences per user**

## Supported Tables

1. **Search Results Table** - The product search dropdown table
2. **Invoice Products Table** - The main POS invoice table (#pos_table)

## How to Access

The Table Designer can be accessed in multiple ways:

1. **Main Button**: Look for the "🎨 Table Designer" button near the search bar or in the filter section
2. **Floating Button**: If the main button is not visible, a floating palette icon button appears in the bottom-right corner
3. **Keyboard Shortcut**: Press `Ctrl+Shift+D` (if implemented) to open the designer

## Features

### Column Customization

1. **Reorder Columns**: 
   - Click and drag the handle icon (☰) to reorder columns
   - Changes are applied instantly

2. **Show/Hide Columns**:
   - Toggle the checkbox next to each column
   - Hidden columns won't appear in the table

3. **Rename Headers**:
   - Edit the text field to change the display name
   - Original column functionality remains unchanged

4. **Adjust Width**:
   - Set custom width for each column in pixels
   - Helps optimize table layout

### Style Customization

1. **Font Settings**:
   - Font Size: Choose from 10px to 16px
   - Font Color: Pick any color for table text

2. **Header Settings**:
   - Header Background: Set background color for headers
   - Header Font Color: Choose header text color

3. **Row Settings**:
   - Row Background: Default row color
   - Alternate Row Background: Color for even rows
   - Hover Background: Color when hovering over rows

## Saving Preferences

- Click "Save Changes" to save your customizations
- Preferences are saved per user and persist across sessions
- Settings are stored both locally and on the server

## Reset to Default

- Click "Reset to Default" to restore original table settings
- This action requires confirmation

## Technical Details

### Files Added:
- `/public/js/table-designer.js` - Main JavaScript functionality
- `/public/css/table-designer.css` - Styling for the designer
- `/app/Http/Controllers/TableDesignerController.php` - Server-side preference handling
- `/database/migrations/2024_01_01_000000_add_settings_to_users_table.php` - Database migration

### Routes Added:
- `POST /table-designer/save-preferences` - Save user preferences
- `GET /table-designer/get-preferences` - Get user preferences

### Dependencies:
- SortableJS - For drag and drop functionality
- Bootstrap Modal - For the designer interface
- jQuery - For DOM manipulation

## Troubleshooting

1. **Button not visible**: Check the bottom-right corner for the floating button
2. **Changes not saving**: Ensure you're logged in and have proper permissions
3. **Styles not applying**: Clear browser cache and reload the page
4. **Column order reset**: Check if preferences were saved successfully

## Future Enhancements

- Export/import table configurations
- Share configurations between users
- Save multiple view templates
- Add more style options (borders, spacing, etc.)
- Column freezing/pinning
- Advanced filtering options 