@php
	$common_settings = session()->get('business.common_settings');
	$multiplier = 1;
	$action = !empty($action) ? $action : '';
@endphp

@foreach($sub_units as $key => $value)
	@if(!empty($product->sub_unit_id) && $product->sub_unit_id == $key)
		@php
			$multiplier = $value['multiplier'];
		@endphp
	@endif
@endforeach

<tr class="product_row" data-row_index="{{$row_count}}" @if(!empty($so_line)) data-so_id="{{$so_line->transaction_id}}" @endif>
	
	<!-- Serial Number -->
	<td class="text-center serial_no">{{$row_count + 1}}</td>
	
	<!-- Product Name -->
	<td class="product_name">
		@if(!empty($so_line))
			<input type="hidden" name="products[{{$row_count}}][so_line_id]" value="{{$so_line->id}}">
		@endif
		
		@php
			$product_name = $product->product_name;
			if(!empty($product->sub_sku)) {
				$product_name .= '<br><small class="text-muted sku-badge">' . $product->sub_sku . '</small>';
			}
			if(!empty($product->brand)) { 
				$product_name .= '<br><small class="text-info">' . $product->brand . '</small>';
			}
		@endphp

		<div class="product-info">
			@if(($edit_price || $edit_discount) && empty($is_direct_sell))
				<span class="text-link text-info cursor-pointer" data-toggle="modal" data-target="#row_edit_product_price_modal_{{$row_count}}" title="@lang('lang_v1.pos_edit_product_price_help')">
					{!! $product_name !!}
					<i class="fa fa-edit fa-xs"></i>
				</span>
			@else
				{!! $product_name !!}
			@endif
			
			@if($product->enable_stock)
				<br><small class="text-muted stock-indicator">
					{{ @num_format($product->qty_available) }} {{$product->unit}} @lang('lang_v1.in_stock')
				</small>
			@endif
		</div>

		<!-- Hidden Fields -->
		<input type="hidden" class="enable_sr_no" value="{{$product->enable_sr_no}}">
		<input type="hidden" class="product_type" name="products[{{$row_count}}][product_type]" value="{{$product->product_type}}">
		<input type="hidden" name="products[{{$row_count}}][product_id]" class="form-control product_id" value="{{$product->product_id}}">
		<input type="hidden" value="{{$product->variation_id}}" name="products[{{$row_count}}][variation_id]" class="row_variation_id">
		<input type="hidden" value="{{$product->enable_stock}}" name="products[{{$row_count}}][enable_stock]">
		<input type="hidden" name="products[{{$row_count}}][product_unit_id]" value="{{$product->unit_id}}">
		<input type="hidden" class="base_unit_multiplier" name="products[{{$row_count}}][base_unit_multiplier]" value="{{$multiplier}}">
		<input type="hidden" class="hidden_base_unit_sell_price" value="{{$product->default_sell_price / $multiplier}}">

		@if(!empty($product->transaction_sell_lines_id))
			<input type="hidden" name="products[{{$row_count}}][transaction_sell_lines_id]" class="form-control" value="{{$product->transaction_sell_lines_id}}">
			<input type="hidden" name="products[{{$row_count}}][is_existing_line]" value="1">
		@endif

		@php
			$hide_tax = 'hide';
			if(session()->get('business.enable_inline_tax') == 1){
				$hide_tax = '';
			}
			
			$tax_id = $product->tax_id;
			$item_tax = !empty($product->item_tax) ? $product->item_tax : 0;
			$unit_price_inc_tax = $product->sell_price_inc_tax;

			if($hide_tax == 'hide'){
				$tax_id = null;
				$unit_price_inc_tax = $product->default_sell_price;
			}

			if(!empty($so_line) && $action !== 'edit') {
				$tax_id = $so_line->tax_id;
				$item_tax = $so_line->item_tax;
				$unit_price_inc_tax = $so_line->unit_price_inc_tax;
			}

			$discount_type = !empty($product->line_discount_type) ? $product->line_discount_type : 'fixed';
			$discount_amount = !empty($product->line_discount_amount) ? $product->line_discount_amount : 0;
			
			if(!empty($discount)) {
				$discount_type = $discount->discount_type;
				$discount_amount = $discount->discount_amount;
			}

			if(!empty($so_line) && $action !== 'edit') {
				$discount_type = $so_line->line_discount_type;
				$discount_amount = $so_line->line_discount_amount;
			}

			$sell_line_note = '';
			if(!empty($product->sell_line_note)){
				$sell_line_note = $product->sell_line_note;
			}
			if(!empty($so_line)){
				$sell_line_note = $so_line->sell_line_note;
			}

			$warranty_id = !empty($action) && $action == 'edit' && !empty($product->warranties->first()) ? $product->warranties->first()->id : $product->warranty_id;

			if($discount_type == 'fixed') {
				$discount_amount = $discount_amount * $multiplier;
			}
		@endphp

		@if(!empty($discount))
			{!! Form::hidden("products[$row_count][discount_id]", $discount->id); !!}
		@endif

		<!-- Lot/Expiry Selection -->
		@if(session()->get('business.enable_lot_number') == 1 || session()->get('business.enable_product_expiry') == 1)
			@php
				$lot_enabled = session()->get('business.enable_lot_number');
				$exp_enabled = session()->get('business.enable_product_expiry');
				$lot_no_line_id = '';
				if(!empty($product->lot_no_line_id)){
					$lot_no_line_id = $product->lot_no_line_id;
				}
			@endphp
			@if(!empty($product->lot_numbers) && empty($is_sales_order))
				<select class="form-control lot_number input-sm" name="products[{{$row_count}}][lot_no_line_id]" @if(!empty($product->transaction_sell_lines_id)) disabled @endif style="margin-top: 5px; font-size: 11px;">
					<option value="">@lang('lang_v1.lot_n_expiry')</option>
					@foreach($product->lot_numbers as $lot_number)
						@php
							$selected = "";
							if($lot_number->purchase_line_id == $lot_no_line_id){
								$selected = "selected";
							}
							if(!empty($purchase_line_id) && $purchase_line_id == $lot_number->purchase_line_id) {
								$selected = "selected";
							}
							$expiry_text = '';
							if($exp_enabled == 1 && !empty($lot_number->exp_date)){
								if(\Carbon::now()->gt(\Carbon::createFromFormat('Y-m-d', $lot_number->exp_date))){
									$expiry_text = '(' . __('report.expired') . ')';
								}
							}
						@endphp
						<option value="{{$lot_number->purchase_line_id}}" data-qty_available="{{$lot_number->qty_available}}" data-msg-max="@lang('lang_v1.quantity_error_msg_in_lot', ['qty'=> $lot_number->qty_formated, 'unit' => $product->unit])" {{$selected}}>
							@if(!empty($lot_number->lot_number) && $lot_enabled == 1){{$lot_number->lot_number}} @endif 
							@if($lot_enabled == 1 && $exp_enabled == 1) - @endif 
							@if($exp_enabled == 1 && !empty($lot_number->exp_date)) @lang('product.exp_date'): {{@format_date($lot_number->exp_date)}} @endif 
							{{$expiry_text}}
						</option>
					@endforeach
				</select>
			@endif
		@endif

		<!-- Modifiers for Restaurant Module -->
		@if(in_array('modifiers', $enabled_modules))
			<div class="modifiers_html">
				@if(!empty($product->product_ms))
					@include('restaurant.product_modifier_set.modifier_for_product', array('edit_modifiers' => true, 'row_count' => $loop->index, 'product_ms' => $product->product_ms))
				@endif
			</div>
		@endif

		<!-- Combo Products Hidden Fields -->
		@if($product->product_type == 'combo' && !empty($product->combo_products))
			@foreach($product->combo_products as $k => $combo_product)
				@if(isset($action) && $action == 'edit')
					@php
						$combo_product['qty_required'] = $combo_product['quantity'] / $product->quantity_ordered;
						$qty_total = $combo_product['quantity'];
					@endphp
				@else
					@php
						$qty_total = $combo_product['qty_required'];
					@endphp
				@endif

				<input type="hidden" name="products[{{$row_count}}][combo][{{$k}}][product_id]" value="{{$combo_product['product_id']}}">
				<input type="hidden" name="products[{{$row_count}}][combo][{{$k}}][variation_id]" value="{{$combo_product['variation_id']}}">
				<input type="hidden" class="combo_product_qty" name="products[{{$row_count}}][combo][{{$k}}][quantity]" data-unit_quantity="{{$combo_product['qty_required']}}" value="{{$qty_total}}">

				@if(isset($action) && $action == 'edit')
					<input type="hidden" name="products[{{$row_count}}][combo][{{$k}}][transaction_sell_lines_id]" value="{{$combo_product['id']}}">
				@endif
			@endforeach
		@endif

		<!-- Edit Product Price Modal -->
		@if(empty($is_direct_sell))
			<div class="modal fade row_edit_product_price_model" id="row_edit_product_price_modal_{{$row_count}}" tabindex="-1" role="dialog">
				@include('sale_pos.partials.row_edit_product_price_modal')
			</div>
		@endif
	</td>

	<!-- Quantity -->
     <td class="text-center">
		<select class="form-control warehouse-selector" name="products[{{$row_count}}][warehouse_id]">
			<option value="">All Warehouses</option>
			<!-- Warehouse options will be populated via JavaScript -->
		</select>
	</td>
	
	<!-- Unit -->
	<td class="text-center">
		@if(count($sub_units) > 0)
			<select name="products[{{$row_count}}][sub_unit_id]" class="form-control input-sm sub_unit">
				@foreach($sub_units as $key => $value)
					<option value="{{$key}}" 
						data-multiplier="{{$value['multiplier']}}" 
						data-unit_name="{{$value['name']}}" 
						data-allow_decimal="{{$value['allow_decimal']}}" 
						@if(!empty($product->sub_unit_id) && $product->sub_unit_id == $key) selected @endif>
						{{$value['name']}}
					</option>
				@endforeach
			</select>
		@else
			<span class="unit-display">{{$product->unit}}</span>
		@endif
	</td>

    <td class="text-center">
		@if(empty($product->quantity_ordered))
			@php
				$product->quantity_ordered = 1;
			@endphp
		@endif

		@php
			$max_quantity = $product->qty_available;
			$formatted_max_quantity = $product->formatted_qty_available;
			$allow_decimal = true;

			if($product->unit_allow_decimal != 1) {
				$allow_decimal = false;
			}

			if(!empty($action) && $action == 'edit') {
				if(!empty($so_line)) {
					$qty_available = $so_line->quantity - $so_line->so_quantity_invoiced + $product->quantity_ordered;
					$max_quantity = $qty_available;
					$formatted_max_quantity = number_format($qty_available, session('business.quantity_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']);
				}
			} else {
				if(!empty($so_line) && $so_line->qty_available <= $max_quantity) {
					$max_quantity = $so_line->qty_available;
					$formatted_max_quantity = $so_line->formatted_qty_available;
				}
			}

			$max_qty_rule = $max_quantity;
			$max_qty_msg = __('validation.custom-messages.quantity_not_available', ['qty'=> $formatted_max_quantity, 'unit' => $product->unit]);
		@endphp

		@foreach($sub_units as $key => $value)
			@if(!empty($product->sub_unit_id) && $product->sub_unit_id == $key)
				@php
					$max_qty_rule = $max_qty_rule / $multiplier;
					$unit_name = $value['name'];
					$max_qty_msg = __('validation.custom-messages.quantity_not_available', ['qty'=> $max_qty_rule, 'unit' => $unit_name]);

					if(!empty($product->lot_no_line_id)){
						$max_qty_msg = __('lang_v1.quantity_error_msg_in_lot', ['qty'=> $max_qty_rule, 'unit' => $unit_name]);
					}

					if($value['allow_decimal']) {
						$allow_decimal = true;
					}
				@endphp
			@endif
		@endforeach

		<input type="text" 
			class="form-control pos_quantity input_number mousetrap input_quantity" 
			value="{{@format_quantity($product->quantity_ordered)}}" 
			name="products[{{$row_count}}][quantity]" 
			data-allow-overselling="@if(empty($pos_settings['allow_overselling'])){{'false'}}@else{{'true'}}@endif"
			@if($allow_decimal) 
				data-decimal=1 
			@else 
				data-decimal=0 
				data-rule-abs_digit="true" 
				data-msg-abs_digit="@lang('lang_v1.decimal_value_not_allowed')" 
			@endif
			data-rule-required="true" 
			data-msg-required="@lang('validation.custom-messages.this_field_is_required')" 
			@if($product->enable_stock && empty($pos_settings['allow_overselling']) && empty($is_sales_order))
				data-rule-max-value="{{$max_qty_rule}}" 
				data-qty_available="{{$product->qty_available}}" 
				data-msg-max-value="{{$max_qty_msg}}" 
				data-msg_max_default="@lang('validation.custom-messages.quantity_not_available', ['qty'=> $product->formatted_qty_available, 'unit' => $product->unit])" 
			@endif>

		@if(!empty($product->second_unit))
			<small class="text-muted">
				@lang('lang_v1.quantity_in_second_unit', ['unit' => $product->second_unit])*:
			</small>
			<input type="text" 
				name="products[{{$row_count}}][secondary_unit_quantity]" 
				value="{{@format_quantity($product->secondary_unit_quantity)}}"
				class="form-control input-sm input_number"
				required>
		@endif
	</td>


	<!-- Price USD -->
	<td class="text-center">
		@php
			$pos_unit_price = !empty($product->unit_price_before_discount) ? $product->unit_price_before_discount : $product->default_sell_price;
			if(!empty($so_line) && $action !== 'edit') {
				$pos_unit_price = $so_line->unit_price_before_discount;
			}
		@endphp
		<input type="text" 
			name="products[{{$row_count}}][unit_price]" 
			class="form-control pos_unit_price input_number mousetrap" 
			value="{{@num_format($pos_unit_price)}}" 
			@if(!empty($pos_settings['enable_msp'])) 
				data-rule-min-value="{{$pos_unit_price}}" 
				data-msg-min-value="{{__('lang_v1.minimum_selling_price_error_msg', ['price' => @num_format($pos_unit_price)])}}" 
			@endif
			@if(!$edit_price && empty($is_direct_sell)) readonly @endif>
	</td>

	<!-- Price IQD -->
	<td class="text-center">
		@php
			$price_iqd = $pos_unit_price * 1300; // Exchange rate
		@endphp
		<input type="text" 
			class="form-control price_iqd input_number" 
			value="{{ $price_iqd }}" 
			readonly>
	</td>

	<!-- Discount % -->
	<td class="text-center">
		<input type="text" 
			class="form-control discount_percent input_number" 
			value="{{$discount_type == 'percentage' ? @num_format($discount_amount) : 0}}"
			name="products[{{$row_count}}][discount_percent]">
		
		{!! Form::hidden("products[$row_count][line_discount_amount]", @num_format($discount_amount), ['class' => 'row_discount_amount']); !!}
		{!! Form::hidden("products[$row_count][line_discount_type]", $discount_type, ['class' => 'row_discount_type']); !!}
	</td>

	<!-- Price inc. tax -->
	<td class="text-center">
		{!! Form::hidden("products[$row_count][item_tax]", @num_format($item_tax), ['class' => 'item_tax']); !!}
		
		<input type="text" 
			name="products[{{$row_count}}][unit_price_inc_tax]" 
			class="form-control pos_unit_price_inc_tax input_number" 
			value="{{@num_format($unit_price_inc_tax)}}" 
			@if(!$edit_price) readonly @endif 
			@if(!empty($pos_settings['enable_msp'])) 
				data-rule-min-value="{{$unit_price_inc_tax}}" 
				data-msg-min-value="{{__('lang_v1.minimum_selling_price_error_msg', ['price' => @num_format($unit_price_inc_tax)])}}" 
			@endif>

		<!-- Hidden Tax Field -->
		<div class="{{$hide_tax}}">
			{!! Form::select("products[$row_count][tax_id]", $tax_dropdown['tax_rates'], $tax_id, ['placeholder' => 'Select', 'class' => 'form-control tax_id'], $tax_dropdown['attributes']); !!}
		</div>
	</td>

	<!-- Subtotal -->
	<td class="text-center">
		@php
			$subtotal_type = !empty($pos_settings['is_pos_subtotal_editable']) ? 'text' : 'hidden';
		@endphp
		<input type="{{$subtotal_type}}" 
			class="form-control pos_line_total @if(!empty($pos_settings['is_pos_subtotal_editable'])) input_number @endif" 
			name="products[{{$row_count}}][line_total]"
			value="{{@num_format($product->quantity_ordered * $unit_price_inc_tax)}}">
		<span class="display_currency pos_line_total_text @if(!empty($pos_settings['is_pos_subtotal_editable'])) hide @endif" data-currency_symbol="true">
			{{$product->quantity_ordered * $unit_price_inc_tax}}
		</span>
	</td>

	<!-- Warehouse -->
	

	<!-- Stock Info -->
	<td class="text-center stock-info-cell">
		@if($product->enable_stock)
			<span class="stock-info stock-available">{{@num_format($product->qty_available)}}</span>
		@else
			<span class="text-muted">N/A</span>
		@endif
	</td>

	<!-- Actions -->
	<td class="text-center">
		<i class="fa fa-times text-danger pos_remove_row cursor-pointer" aria-hidden="true" title="Remove Item"></i>
	</td>

	<!-- Service Staff (Restaurant Module) -->
	@if(!empty($pos_settings['inline_service_staff']))
		<td class="hide">
			{!! Form::select("products[" . $row_count . "][res_service_staff_id]", $waiters, !empty($product->res_service_staff_id) ? $product->res_service_staff_id : null, ['class' => 'form-control select2 order_line_service_staff', 'placeholder' => __('restaurant.select_service_staff'), 'required' => (!empty($pos_settings['is_service_staff_required']) && $pos_settings['is_service_staff_required'] == 1) ? true : false]); !!}
		</td>
	@endif

	<!-- Warranty (if enabled) -->
	@if(!empty($common_settings['enable_product_warranty']) && !empty($is_direct_sell))
		<td class="hide">
			{!! Form::select("products[$row_count][warranty_id]", $warranties, $warranty_id, ['placeholder' => __('messages.please_select'), 'class' => 'form-control']); !!}
		</td>
	@endif

	<!-- Direct Sell Note -->
	@if(!empty($is_direct_sell))
		<td class="hide" colspan="13">
			<textarea class="form-control" name="products[{{$row_count}}][sell_line_note]" rows="2" placeholder="@lang('lang_v1.sell_line_description_help')">{{$sell_line_note}}</textarea>
		</td>
	@endif
</tr>

<!-- Additional CSS for this row -->
<style>
.product-info {
	line-height: 1.3;
}

.sku-badge {
	display: inline-block;
	padding: 1px 4px;
	background-color: #e9ecef;
	color: #495057;
	border-radius: 3px;
	font-size: 10px;
	font-weight: 500;
}

.stock-indicator {
	font-size: 10px;
	color: #6c757d;
}

.unit-display {
	font-weight: 500;
	color: #495057;
}

.warehouse-selector {
	font-size: 11px;
}

.pos_remove_row {
	transition: all 0.2s ease;
}

.pos_remove_row:hover {
	transform: scale(1.2);
	color: #dc3545 !important;
}

/* Input field styling within the row */
.product_row input.form-control,
.product_row select.form-control {
	font-size: 12px;
	padding: 2px 4px;
	height: 28px;
	border: 1px solid #ddd;
	border-radius: 3px;
}

.product_row input.form-control:focus,
.product_row select.form-control:focus {
	border-color: #556270;
	box-shadow: 0 0 0 2px rgba(85, 98, 112, 0.1);
}

.product_row .pos_quantity,
.product_row .pos_unit_price,
.product_row .price_iqd,
.product_row .discount_percent,
.product_row .pos_unit_price_inc_tax {
	text-align: center;
	background-color: #f8f9fa;
}

.product_row .pos_line_total_text {
	font-weight: 600;
	color: #2c3e50;
}
</style>