<!-- قالب فاتورة باللغة العربية - تصميم من اليمين إلى اليسار -->
<div dir="rtl" style="color: #000000 !important; font-family: Arial, sans-serif;">
    <!-- الترويسة مع الشعارات -->
    <div class="row" style="margin-bottom: 20px;">
        <div class="col-xs-4" style="float: right; width: 33%;">
            <!-- الباركود والفرع -->
            <div style="text-align: center;">
                <div style="background-color: #f9a825; color: #000; padding: 5px 10px; font-weight: bold; display: inline-block; margin-bottom: 10px;">
                    فرع {{ $receipt_details->location_name ?? 'الصرافية' }}
                </div>
                @if(!empty($receipt_details->barcode))
                    <div style="margin-top: 10px;">
                        <img src="{{ $receipt_details->barcode }}" alt="Barcode" style="max-width: 100%;">
                    </div>
                @endif
            </div>
        </div>
        <div class="col-xs-4" style="float: right; width: 33%; text-align: center;">
            <!-- شعار وعنوان -->
            <div style="text-align: center;">
                <div style="background-color: #f9a825; color: #000; padding: 5px 10px; font-weight: bold; display: inline-block; margin-bottom: 10px;">
                    {{ $receipt_details->invoice_heading ?? 'أمر مبيع' }}
                </div>
                @if(!empty($receipt_details->logo))
                    <div style="margin-top: 10px;">
                        <img src="{{ $receipt_details->logo }}" alt="Logo" style="max-width: 100px;">
                    </div>
                @endif
            </div>
        </div>
        <div class="col-xs-4" style="float: left; width: 33%; text-align: center;">
            <!-- شعار الشركة الثانوي إن وجد -->
            @if(!empty($receipt_details->secondary_logo))
                <div style="text-align: center;">
                    <img src="{{ $receipt_details->secondary_logo }}" alt="Secondary Logo" style="max-width: 150px;">
                </div>
            @endif
        </div>
    </div>

    <div style="clear: both;"></div>

    <!-- معلومات الفاتورة -->
    <div class="row" style="margin-bottom: 20px;">
        <div class="col-xs-6" style="float: right; width: 50%;">
            <table style="width: 100%; border-collapse: collapse; border: 1px solid #ddd;">
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd; width: 40%;">{{ $receipt_details->invoice_no_prefix ?? 'رقم الفاتورة' }}</td>
                    <td style="padding: 8px; border: 1px solid #ddd; width: 60%;">{{ $receipt_details->invoice_no }}</td>
                </tr>
                @if(!empty($receipt_details->sap_document_id))
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;">رقم SAP</td>
                    <td style="padding: 8px; border: 1px solid #ddd;">{{ $receipt_details->sap_document_id }}</td>
                </tr>
                @endif
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;">{{ $receipt_details->date_label ?? 'التاريخ' }}</td>
                    <td style="padding: 8px; border: 1px solid #ddd;">{{ $receipt_details->invoice_date }}</td>
                </tr>
                @if(!empty($receipt_details->due_date_label))
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;">{{ $receipt_details->due_date_label }}</td>
                    <td style="padding: 8px; border: 1px solid #ddd;">{{ $receipt_details->due_date }}</td>
                </tr>
                @endif
                
                @if(!empty($receipt_details->sales_person_label))
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;">{{ $receipt_details->sales_person_label }}</td>
                    <td style="padding: 8px; border: 1px solid #ddd;">{{ $receipt_details->sales_person }}</td>
                </tr>
                @endif
            </table>
            
            <table style="width: 100%; border-collapse: collapse; border: 1px solid #ddd; margin-top: 10px;">
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd; width: 40%;">{{ $receipt_details->client_id_label ?? 'رمز العميل' }}</td>
                    <td style="padding: 8px; border: 1px solid #ddd; width: 60%;">{{ $receipt_details->client_id }}</td>
                </tr>
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;">{{ $receipt_details->invoice_type_label ?? 'نوع الفاتورة' }}</td>
                    <td style="padding: 8px; border: 1px solid #ddd;">{{ $receipt_details->invoice_type ?? 'آجل' }}</td>
                </tr>
                
                @if(!empty($receipt_details->commission_agent_label))
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;">{{ $receipt_details->commission_agent_label }}</td>
                    <td style="padding: 8px; border: 1px solid #ddd;">{{ $receipt_details->commission_agent }}</td>
                </tr>
                @endif
                
                @if(!empty($receipt_details->customer_rp_label))
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;">{{ $receipt_details->customer_rp_label }}</td>
                    <td style="padding: 8px; border: 1px solid #ddd;">{{ $receipt_details->customer_total_rp }}</td>
                </tr>
                @endif
            </table>
            
            <!-- معلومات الإصلاح إذا وجدت -->
            @if(!empty($receipt_details->repair_brand) || !empty($receipt_details->repair_device) || !empty($receipt_details->repair_model_no) || !empty($receipt_details->repair_serial_no) || !empty($receipt_details->repair_status) || !empty($receipt_details->repair_warranty))
            <table style="width: 100%; border-collapse: collapse; border: 1px solid #ddd; margin-top: 10px;">
                @if(!empty($receipt_details->brand_label) || !empty($receipt_details->repair_brand))
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd; width: 40%;">{{ $receipt_details->brand_label ?? 'العلامة التجارية' }}</td>
                    <td style="padding: 8px; border: 1px solid #ddd; width: 60%;">{{ $receipt_details->repair_brand }}</td>
                </tr>
                @endif
                
                @if(!empty($receipt_details->device_label) || !empty($receipt_details->repair_device))
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;">{{ $receipt_details->device_label ?? 'الجهاز' }}</td>
                    <td style="padding: 8px; border: 1px solid #ddd;">{{ $receipt_details->repair_device }}</td>
                </tr>
                @endif
                
                @if(!empty($receipt_details->model_no_label) || !empty($receipt_details->repair_model_no))
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;">{{ $receipt_details->model_no_label ?? 'رقم الموديل' }}</td>
                    <td style="padding: 8px; border: 1px solid #ddd;">{{ $receipt_details->repair_model_no }}</td>
                </tr>
                @endif
                
                @if(!empty($receipt_details->serial_no_label) || !empty($receipt_details->repair_serial_no))
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;">{{ $receipt_details->serial_no_label ?? 'الرقم التسلسلي' }}</td>
                    <td style="padding: 8px; border: 1px solid #ddd;">{{ $receipt_details->repair_serial_no }}</td>
                </tr>
                @endif
                
                @if(!empty($receipt_details->repair_status_label) || !empty($receipt_details->repair_status))
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;">{{ $receipt_details->repair_status_label ?? 'حالة الإصلاح' }}</td>
                    <td style="padding: 8px; border: 1px solid #ddd;">{{ $receipt_details->repair_status }}</td>
                </tr>
                @endif
                
                @if(!empty($receipt_details->repair_warranty_label) || !empty($receipt_details->repair_warranty))
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;">{{ $receipt_details->repair_warranty_label ?? 'الضمان' }}</td>
                    <td style="padding: 8px; border: 1px solid #ddd;">{{ $receipt_details->repair_warranty }}</td>
                </tr>
                @endif
            </table>
            @endif
        </div>

        <div class="col-xs-6" style="float: left; width: 50%;">
            <table style="width: 95%; margin-left: 0; margin-right: auto; border-collapse: collapse; border: 1px solid #ddd;">
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;">{{ $receipt_details->customer_label ?? 'فاتورة إلى' }}</td>
                </tr>
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        @if(!empty($receipt_details->customer_name))
                            {{ $receipt_details->customer_name }}
                        @else
                            {{ $receipt_details->customer_info ?? 'نقدي صرافية بالمحل' }}
                        @endif
                    </td>
                </tr>
                @if(!empty($receipt_details->address))
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">{!! $receipt_details->address !!}</td>
                </tr>
                @endif
                @if(!empty($receipt_details->contact))
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd; direction: ltr; text-align: right;">{{ $receipt_details->contact }}</td>
                </tr>
                @endif
                @if(!empty($receipt_details->customer_tax_label))
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">{{ $receipt_details->customer_tax_label }}: {{ $receipt_details->customer_tax_number }}</td>
                </tr>
                @endif
                
                <!-- معلومات الطاولة والنادل -->
                @if(!empty($receipt_details->table_label) || !empty($receipt_details->table))
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        @if(!empty($receipt_details->table_label))
                            <b>{{ $receipt_details->table_label }}</b>
                        @endif
                        {{ $receipt_details->table }}
                    </td>
                </tr>
                @endif
                
                @if(!empty($receipt_details->service_staff_label) || !empty($receipt_details->service_staff))
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        @if(!empty($receipt_details->service_staff_label))
                            <b>{{ $receipt_details->service_staff_label }}</b>
                        @endif
                        {{ $receipt_details->service_staff }}
                    </td>
                </tr>
                @endif
                
                <!-- معلومات الشحن المخصصة -->
                @if(!empty($receipt_details->shipping_custom_field_1_label))
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong>{{ $receipt_details->shipping_custom_field_1_label }}:</strong> 
                        {{ $receipt_details->shipping_custom_field_1_value ?? '' }}
                    </td>
                </tr>
                @endif
                
                @if(!empty($receipt_details->shipping_custom_field_2_label))
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong>{{ $receipt_details->shipping_custom_field_2_label }}:</strong> 
                        {{ $receipt_details->shipping_custom_field_2_value ?? '' }}
                    </td>
                </tr>
                @endif
                
                @if(!empty($receipt_details->shipping_custom_field_3_label))
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong>{{ $receipt_details->shipping_custom_field_3_label }}:</strong> 
                        {{ $receipt_details->shipping_custom_field_3_value ?? '' }}
                    </td>
                </tr>
                @endif
                
                @if(!empty($receipt_details->shipping_custom_field_4_label))
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong>{{ $receipt_details->shipping_custom_field_4_label }}:</strong> 
                        {{ $receipt_details->shipping_custom_field_4_value ?? '' }}
                    </td>
                </tr>
                @endif
                
                @if(!empty($receipt_details->shipping_custom_field_5_label))
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong>{{ $receipt_details->shipping_custom_field_5_label }}:</strong> 
                        {{ $receipt_details->shipping_custom_field_5_value ?? '' }}
                    </td>
                </tr>
                @endif
                
                <!-- أرقام طلبات البيع -->
                @if(!empty($receipt_details->sale_orders_invoice_no))
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong>@lang('restaurant.order_no'):</strong> 
                        {{ $receipt_details->sale_orders_invoice_no ?? '' }}
                    </td>
                </tr>
                @endif
                
                @if(!empty($receipt_details->sale_orders_invoice_date))
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong>@lang('lang_v1.order_dates'):</strong> 
                        {{ $receipt_details->sale_orders_invoice_date ?? '' }}
                    </td>
                </tr>
                @endif
                
                <!-- حقول مخصصة للبيع -->
                @if(!empty($receipt_details->sell_custom_field_1_value))
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong>{{ $receipt_details->sell_custom_field_1_label }}:</strong> 
                        {{ $receipt_details->sell_custom_field_1_value ?? '' }}
                    </td>
                </tr>
                @endif
                
                @if(!empty($receipt_details->sell_custom_field_2_value))
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong>{{ $receipt_details->sell_custom_field_2_label }}:</strong> 
                        {{ $receipt_details->sell_custom_field_2_value ?? '' }}
                    </td>
                </tr>
                @endif
                
                @if(!empty($receipt_details->sell_custom_field_3_value))
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong>{{ $receipt_details->sell_custom_field_3_label }}:</strong> 
                        {{ $receipt_details->sell_custom_field_3_value ?? '' }}
                    </td>
                </tr>
                @endif
                
                @if(!empty($receipt_details->sell_custom_field_4_value))
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong>{{ $receipt_details->sell_custom_field_4_label }}:</strong> 
                        {{ $receipt_details->sell_custom_field_4_value ?? '' }}
                    </td>
                </tr>
                @endif
            </table>
            
            @if(!empty($receipt_details->types_of_service))
            <table style="width: 95%; margin-left: 0; margin-right: auto; border-collapse: collapse; border: 1px solid #ddd; margin-top: 10px;">
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong>{{ $receipt_details->types_of_service_label }}:</strong> 
                        {{ $receipt_details->types_of_service }}
                        <!-- معلومات نوع الخدمة المخصصة -->
                        @if(!empty($receipt_details->types_of_service_custom_fields))
                            @foreach($receipt_details->types_of_service_custom_fields as $key => $value)
                                <br><strong>{{ $key }}:</strong> {{ $value }}
                            @endforeach
                        @endif
                    </td>
                </tr>
            </table>
            @endif
        </div>
    </div>

    <div style="clear: both;"></div>

    <!-- جزء إصلاح مشترك إذا كان موجوداً -->
    @includeIf('sale_pos.receipts.partial.common_repair_invoice')

    <!-- جدول المنتجات -->
    <div class="row">
        <div class="col-xs-12">
            <table style="width: 100%; border-collapse: collapse; border: 1px solid #ddd;">
                <thead>
                    <tr>
                        <th style="padding: 8px; text-align: center; border: 1px solid #ddd; background-color: #f0f0f0;">ت</th>
                        <th style="padding: 8px; text-align: center; border: 1px solid #ddd; background-color: #f0f0f0;">تسلسل</th>
                        <th style="padding: 8px; text-align: right; border: 1px solid #ddd; background-color: #f0f0f0;">{{ $receipt_details->table_product_label ?? 'الوصف' }}</th>
                        <th style="padding: 8px; text-align: center; border: 1px solid #ddd; background-color: #f0f0f0;">{{ $receipt_details->table_qty_label ?? 'الكمية' }}</th>
                        <th style="padding: 8px; text-align: center; border: 1px solid #ddd; background-color: #f0f0f0;">{{ $receipt_details->table_unit_label ?? 'الوحدة' }}</th>
                        <th style="padding: 8px; text-align: center; border: 1px solid #ddd; background-color: #f0f0f0;">{{ $receipt_details->table_unit_price_label ?? 'السعر' }}</th>
                        @if(!empty($receipt_details->discounted_unit_price_label))
                            <th style="padding: 8px; text-align: center; border: 1px solid #ddd; background-color: #f0f0f0;">{{ $receipt_details->discounted_unit_price_label }}</th>
                        @endif
                        @if(!empty($receipt_details->item_discount_label))
                            <th style="padding: 8px; text-align: center; border: 1px solid #ddd; background-color: #f0f0f0;">{{ $receipt_details->item_discount_label }}</th>
                        @endif
                        <th style="padding: 8px; text-align: center; border: 1px solid #ddd; background-color: #f0f0f0;">{{ $receipt_details->table_subtotal_label ?? 'السعر الإجمالي' }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($receipt_details->lines as $index => $line)
                        <tr style="{{ $index % 2 == 0 ? 'background-color: #f9f9f9;' : 'background-color: #e6e6e6;' }}">
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">{{ isset($line['custom_field_1']) ? $line['custom_field_1'] : ($index + 1) }}</td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">{{ str_pad($index + 1, 3, '0', STR_PAD_LEFT) }}</td>
                            <td style="padding: 8px; text-align: right; border: 1px solid #ddd;">
                                @if(!empty($line['image']))
                                    <img src="{{ $line['image'] }}" alt="صورة المنتج" width="50" style="float: right; margin-left: 8px;">
                                @endif
                                {{ $line['name'] }} {{ $line['product_variation'] }} {{ $line['variation'] }}
                                @if(!empty($line['sub_sku'])), {{ $line['sub_sku'] }} @endif 
                                @if(!empty($line['brand'])), {{ $line['brand'] }} @endif 
                                @if(!empty($line['cat_code'])), {{ $line['cat_code'] }}@endif
                                @if(!empty($line['product_custom_fields'])), {{ $line['product_custom_fields'] }} @endif
                                
                                @if(!empty($line['product_description']))
                                    <br><small>{!! $line['product_description'] !!}</small>
                                @endif
                                
                                @if(!empty($line['sell_line_note']))
                                    <br><small>{!! $line['sell_line_note'] !!}</small>
                                @endif
                                
                                @if(!empty($line['lot_number']))
                                    <br> {{ $line['lot_number_label'] }}: {{ $line['lot_number'] }}
                                @endif
                                
                                @if(!empty($line['product_expiry']))
                                    , {{ $line['product_expiry_label'] }}: {{ $line['product_expiry'] }}
                                @endif
                                
                                @if(!empty($line['warranty_name']))
                                    <br><small>{{ $line['warranty_name'] }}</small>
                                @endif 
                                
                                @if(!empty($line['warranty_exp_date']))
                                    <small>- {{ @format_date($line['warranty_exp_date']) }}</small>
                                @endif
                                
                                @if(!empty($line['warranty_description']))
                                    <small> {{ $line['warranty_description'] ?? '' }}</small>
                                @endif
                                
                                @if($receipt_details->show_base_unit_details && $line['quantity'] && $line['base_unit_multiplier'] !== 1)
                                    <br><small>
                                        1 {{ $line['units'] }} = {{ $line['base_unit_multiplier'] }} {{ $line['base_unit_name'] }} <br>
                                        {{ $line['base_unit_price'] }} x {{ $line['orig_quantity'] }} = {{ $line['line_total'] }}
                                    </small>
                                @endif
                            </td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">
                                {{ $line['quantity'] }} {{ $line['units'] }}
                                
                                @if($receipt_details->show_base_unit_details && $line['quantity'] && $line['base_unit_multiplier'] !== 1)
                                    <br><small>
                                        {{ $line['quantity'] }} x {{ $line['base_unit_multiplier'] }} = {{ $line['orig_quantity'] }} {{ $line['base_unit_name'] }}
                                    </small>
                                @endif
                            </td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">{{ $line['units'] ?? 'غم 100' }}</td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">{{ $line['unit_price_before_discount'] }} د.ع</td>
                            
                            @if(!empty($receipt_details->discounted_unit_price_label))
                                <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">{{ $line['unit_price_inc_tax'] }} د.ع</td>
                            @endif
                            
                            @if(!empty($receipt_details->item_discount_label))
                                <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">
                                    {{ $line['total_line_discount'] ?? '0.00' }}
                                    @if(!empty($line['line_discount_percent']))
                                        ({{ $line['line_discount_percent'] }}%)
                                    @endif
                                </td>
                            @endif
                            
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">{{ $line['line_total'] }} د.ع</td>
                        </tr>
                        
                        @if(!empty($line['modifiers']))
                            @foreach($line['modifiers'] as $modifier)
                                <tr style="background-color: #f9f9f9;">
                                    <td style="padding: 8px; text-align: center; border: 1px solid #ddd;"></td>
                                    <td style="padding: 8px; text-align: center; border: 1px solid #ddd;"></td>
                                    <td style="padding: 8px; text-align: right; border: 1px solid #ddd;">
                                        {{ $modifier['name'] }} {{ $modifier['variation'] }}
                                        @if(!empty($modifier['sub_sku'])), {{ $modifier['sub_sku'] }} @endif 
                                        @if(!empty($modifier['cat_code'])), {{ $modifier['cat_code'] }}@endif
                                        @if(!empty($modifier['sell_line_note']))
                                            ({{ $modifier['sell_line_note'] }})
                                        @endif
                                    </td>
                                    <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">{{ $modifier['quantity'] }} {{ $modifier['units'] }}</td>
                                    <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">{{ $modifier['units'] }}</td>
                                    <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">{{ $modifier['unit_price_inc_tax'] }} د.ع</td>
                                    
                                    @if(!empty($receipt_details->discounted_unit_price_label))
                                        <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">{{ $modifier['unit_price_exc_tax'] }} د.ع</td>
                                    @endif
                                    
                                    @if(!empty($receipt_details->item_discount_label))
                                        <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">0.00</td>
                                    @endif
                                    
                                    <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">{{ $modifier['line_total'] }} د.ع</td>
                                </tr>
                            @endforeach
                        @endif
                    @empty
                        <!-- قائمة افتراضية إذا لم تكن هناك منتجات -->
                        <tr style="background-color: #f9f9f9;">
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">4</td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">001</td>
                            <td style="padding: 8px; text-align: right; border: 1px solid #ddd;">W بربري - ADF</td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">1.00</td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">غم 100</td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">10,010 د.ع</td>
                            @if(!empty($receipt_details->discounted_unit_price_label))
                                <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">10,010 د.ع</td>
                            @endif
                            @if(!empty($receipt_details->item_discount_label))
                                <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">0.00</td>
                            @endif
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">10,010 د.ع</td>
                        </tr>
                        <tr style="background-color: #e6e6e6;">
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">5</td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">002</td>
                            <td style="padding: 8px; text-align: right; border: 1px solid #ddd;">لافي بيلي/لانكوم - ADF</td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">1.00</td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">غم 100</td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">11,440 د.ع</td>
                            @if(!empty($receipt_details->discounted_unit_price_label))
                                <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">11,440 د.ع</td>
                            @endif
                            @if(!empty($receipt_details->item_discount_label))
                                <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">0.00</td>
                            @endif
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">11,440 د.ع</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- معلومات المدفوعات والإجماليات -->
    <div class="row" style="margin-top: 20px;">
        <div class="col-xs-6" style="float: right; width: 45%;">
            <!-- معلومات المدفوعات -->
            <table style="width: 100%; border-collapse: collapse; margin-bottom: 15px;">
                @if(!empty($receipt_details->payments))
                    @foreach($receipt_details->payments as $payment)
                        <tr>
                            <td style="padding: 5px;">{{ $payment['method'] }}</td>
                            <td style="padding: 5px; text-align: left;">{{ $payment['amount'] }}</td>
                            <td style="padding: 5px; text-align: left;">{{ $payment['date'] }}</td>
                        </tr>
                    @endforeach
                @endif
                
                <!-- إجمالي المدفوع -->
                @if(!empty($receipt_details->total_paid))
                    <tr>
                        <th style="padding: 8px; text-align: right; font-weight: bold;">
                            {!! $receipt_details->total_paid_label !!}
                        </th>
                        <td style="padding: 8px; text-align: left;">
                            {{ $receipt_details->total_paid }}
                        </td>
                    </tr>
                @endif
                
                <!-- المستحق -->
                @if(!empty($receipt_details->total_due) && !empty($receipt_details->total_due_label))
                    <tr>
                        <th style="padding: 8px; text-align: right; font-weight: bold;">
                            {!! $receipt_details->total_due_label !!}
                        </th>
                        <td style="padding: 8px; text-align: left;">
                            {{ $receipt_details->total_due }}
                        </td>
                    </tr>
                @endif
                
                @if(!empty($receipt_details->all_due))
                    <tr>
                        <th style="padding: 8px; text-align: right; font-weight: bold;">
                            {!! $receipt_details->all_bal_label !!}
                        </th>
                        <td style="padding: 8px; text-align: left;">
                            {{ $receipt_details->all_due }}
                        </td>
                    </tr>
                @endif
            </table>
            
            <!-- ملخص الحساب -->
            <table style="width: 100%; border-collapse: collapse;">
                <tr>
                    <td style="padding: 8px; text-align: center; border: 1px solid #ddd; background-color: #f9a825; font-weight: bold;">{{ $receipt_details->subtotal_label ?? 'المجموع' }}</td>
                    <td style="padding: 8px; text-align: left; border: 1px solid #ddd;">{{ $receipt_details->subtotal ?? '191,620 د.ع' }}</td>
                </tr>
                <tr>
                    <td style="padding: 8px; text-align: center; border: 1px solid #ddd; background-color: #f9a825; font-weight: bold;">{{ $receipt_details->previous_balance_label ?? 'الرصيد السابق' }}</td>
                    <td style="padding: 8px; text-align: left; border: 1px solid #ddd;">{{ $receipt_details->previous_balance ?? '-15.93' }}</td>
                </tr>
                <tr>
                    <td style="padding: 8px; text-align: center; border: 1px solid #ddd; background-color: #f9a825; font-weight: bold;">{{ $receipt_details->total_due_label ?? 'إجمالي الحساب' }}</td>
                    <td style="padding: 8px; text-align: left; border: 1px solid #ddd;">{{ $receipt_details->total_due ?? '118.07' }}</td>
                </tr>
            </table>
        </div>
        
        <div class="col-xs-6" style="float: left; width: 55%;">
            <!-- تفاصيل الإجمالي -->
            <table style="width: 100%; border-collapse: collapse; margin-bottom: 15px;">
                @if(!empty($receipt_details->total_quantity_label))
                    <tr>
                        <th style="padding: 5px; text-align: right; width: 70%;">
                            {!! $receipt_details->total_quantity_label !!}
                        </th>
                        <td style="padding: 5px; text-align: left;">
                            {{ $receipt_details->total_quantity }}
                        </td>
                    </tr>
                @endif
                
                @if(!empty($receipt_details->total_items_label))
                    <tr>
                        <th style="padding: 5px; text-align: right; width: 70%;">
                            {!! $receipt_details->total_items_label !!}
                        </th>
                        <td style="padding: 5px; text-align: left;">
                            {{ $receipt_details->total_items }}
                        </td>
                    </tr>
                @endif
                
                @if(!empty($receipt_details->total_exempt_uf))
                    <tr>
                        <th style="padding: 5px; text-align: right; width: 70%;">
                            @lang('lang_v1.exempt')
                        </th>
                        <td style="padding: 5px; text-align: left;">
                            {{ $receipt_details->total_exempt }}
                        </td>
                    </tr>
                @endif
                
                <!-- رسوم الشحن -->
                @if(!empty($receipt_details->shipping_charges))
                    <tr>
                        <th style="padding: 5px; text-align: right; width: 70%;">
                            {!! $receipt_details->shipping_charges_label !!}
                        </th>
                        <td style="padding: 5px; text-align: left;">
                            {{ $receipt_details->shipping_charges }}
                        </td>
                    </tr>
                @endif
                
                @if(!empty($receipt_details->packing_charge))
                    <tr>
                        <th style="padding: 5px; text-align: right; width: 70%;">
                            {!! $receipt_details->packing_charge_label !!}
                        </th>
                        <td style="padding: 5px; text-align: left;">
                            {{ $receipt_details->packing_charge }}
                        </td>
                    </tr>
                @endif
                
                <!-- الخصم -->
                @if(!empty($receipt_details->discount))
                    <tr>
                        <th style="padding: 5px; text-align: right; width: 70%;">
                            {!! $receipt_details->discount_label !!}
                        </th>
                        <td style="padding: 5px; text-align: left;">
                            (-) {{ $receipt_details->discount }}
                        </td>
                    </tr>
                @endif
                
                @if(!empty($receipt_details->total_line_discount))
                    <tr>
                        <th style="padding: 5px; text-align: right; width: 70%;">
                            {!! $receipt_details->line_discount_label !!}
                        </th>
                        <td style="padding: 5px; text-align: left;">
                            (-) {{ $receipt_details->total_line_discount }}
                        </td>
                    </tr>
                @endif
                
                @if(!empty($receipt_details->additional_expenses))
                    @foreach($receipt_details->additional_expenses as $key => $val)
                        <tr>
                            <td style="padding: 5px; text-align: right; width: 70%;">
                                {{ $key }}:
                            </td>
                            <td style="padding: 5px; text-align: left;">
                                (+) {{ $val }}
                            </td>
                        </tr>
                    @endforeach
                @endif
                
                @if(!empty($receipt_details->reward_point_label))
                    <tr>
                        <th style="padding: 5px; text-align: right; width: 70%;">
                            {!! $receipt_details->reward_point_label !!}
                        </th>
                        <td style="padding: 5px; text-align: left;">
                            (-) {{ $receipt_details->reward_point_amount }}
                        </td>
                    </tr>
                @endif
                
                <!-- الضريبة -->
                @if(!empty($receipt_details->tax))
                    <tr>
                        <th style="padding: 5px; text-align: right; width: 70%;">
                            {!! $receipt_details->tax_label !!}
                        </th>
                        <td style="padding: 5px; text-align: left;">
                            (+) {{ $receipt_details->tax }}
                        </td>
                    </tr>
                @endif
                
                @if($receipt_details->round_off_amount > 0)
                    <tr>
                        <th style="padding: 5px; text-align: right; width: 70%;">
                            {!! $receipt_details->round_off_label !!}
                        </th>
                        <td style="padding: 5px; text-align: left;">
                            {{ $receipt_details->round_off }}
                        </td>
                    </tr>
                @endif
                
                <!-- الإجمالي -->
                <tr>
                    <th style="padding: 5px; text-align: right; width: 70%;">
                        {!! $receipt_details->total_label !!}
                    </th>
                    <td style="padding: 5px; text-align: left;">
                        {{ $receipt_details->total }}
                        @if(!empty($receipt_details->total_in_words))
                            <br>
                            <small>({{ $receipt_details->total_in_words }})</small>
                        @endif
                    </td>
                </tr>
            </table>
            
            <!-- المجموع بالدينار العراقي -->
            <div style="border: 1px solid #ddd; margin-bottom: 20px;">
                <div style="padding: 8px; text-align: center; border-bottom: 1px solid #ddd; background-color: #f9a825; font-weight: bold;">
                    المجموع بالدينار العراقي
                </div>
                <div style="padding: 15px; text-align: center; font-size: 24px; font-weight: bold;">
                    {{ $receipt_details->total_in_words ?? '١٩٢,٠٠٠.٠٠' }}
                </div>
            </div>
            
            <!-- ملخص الضريبة -->
            @if(empty($receipt_details->hide_price) && !empty($receipt_details->tax_summary_label))
                @if(!empty($receipt_details->taxes))
                    <table style="width: 100%; border-collapse: collapse; margin-bottom: 15px; border: 1px solid #ddd;">
                        <tr>
                            <th colspan="2" style="padding: 8px; text-align: center; border-bottom: 1px solid #ddd; background-color: #f9a825;">{{ $receipt_details->tax_summary_label }}</th>
                        </tr>
                        @foreach($receipt_details->taxes as $key => $val)
                            <tr>
                                <td style="padding: 5px; text-align: center; border-right: 1px solid #ddd;"><b>{{ $key }}</b></td>
                                <td style="padding: 5px; text-align: center;">{{ $val }}</td>
                            </tr>
                        @endforeach
                    </table>
                @endif
            @endif
        </div>
    </div>

    <div style="clear: both;"></div>

    <!-- ملاحظات إضافية -->
    @if(!empty($receipt_details->additional_notes))
        <div class="row" style="margin-top: 15px;">
            <div class="col-xs-12">
                <p style="margin-bottom: 15px;">{!! nl2br($receipt_details->additional_notes) !!}</p>
            </div>
        </div>
    @endif

    <!-- معلومات الاتصال والصفحة -->
    <div style="margin-top: 30px; border-top: 3px solid #f9a825; padding-top: 10px;">
        <div style="float: left; width: 10%;">
            <div style="padding: 5px; text-align: center; border: 1px solid #ddd; background-color: #f9a825; font-weight: bold; display: inline-block;">
                1/1
            </div>
        </div>
        <div style="float: right; width: 90%; text-align: right;">
            <p>بغداد - الشورجة - مجاور خان حميد النجــــار / 07711386000-07700004472</p>
            <p>بغداد - الصرافية - مجاور جامع عادلة خاتون / 07714440002-07700004462</p>
        </div>
    </div>
</div>