@extends('layouts.app')
@section('title', __('SAP Integration'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('SAP B1 Integration')</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="row">
                    <div class="col-md-6">
                        <div class="box box-solid">
                            <div class="box-header with-border">
                                <h3 class="box-title">@lang('Products Synchronization')</h3>
                            </div>
                            <div class="box-body">
                                <form action="{{ route('sap.sync.products') }}" method="POST" id="sync-products-form">
                                    @csrf
                                    <div class="form-group">
                                        <label>
                                            <input type="checkbox" name="full_sync" value="1"> 
                                            @lang('Perform full sync (may take longer)')
                                        </label>
                                    </div>
                                    <button type="submit" class="btn btn-primary">@lang('Sync Products from SAP')</button>
                                </form>
                                <div class="sync-status" id="products-sync-status" style="display: none;">
                                    <hr>
                                    <div class="alert alert-info sync-message">
                                        <i class="fa fa-spinner fa-spin"></i> @lang('Syncing products...')
                                    </div>
                                    <div class="sync-results" style="display: none;">
                                        <h4>@lang('Results'):</h4>
                                        <table class="table table-bordered table-striped">
                                            <tr>
                                                <th>@lang('Total Items')</th>
                                                <td class="total-count">0</td>
                                            </tr>
                                            <tr>
                                                <th>@lang('Created')</th>
                                                <td class="created-count">0</td>
                                            </tr>
                                            <tr>
                                                <th>@lang('Updated')</th>
                                                <td class="updated-count">0</td>
                                            </tr>
                                            <tr>
                                                <th>@lang('Skipped')</th>
                                                <td class="skipped-count">0</td>
                                            </tr>
                                            <tr>
                                                <th>@lang('Failed')</th>
                                                <td class="failed-count">0</td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="box box-solid">
                            <div class="box-header with-border">
                                <h3 class="box-title">@lang('Contacts Synchronization')</h3>
                            </div>
                            <div class="box-body">
                                <form action="{{ route('sap.sync.contacts') }}" method="POST" id="sync-contacts-form">
                                    @csrf
                                    <div class="form-group">
                                        <label>
                                            <input type="checkbox" name="full_sync" value="1"> 
                                            @lang('Perform full sync (may take longer)')
                                        </label>
                                    </div>
                                    <button type="submit" class="btn btn-primary">@lang('Sync Contacts from SAP')</button>
                                </form>
                                <div class="sync-status" id="contacts-sync-status" style="display: none;">
                                    <hr>
                                    <div class="alert alert-info sync-message">
                                        <i class="fa fa-spinner fa-spin"></i> @lang('Syncing contacts...')
                                    </div>
                                    <div class="sync-results" style="display: none;">
                                        <h4>@lang('Results'):</h4>
                                        <table class="table table-bordered table-striped">
                                            <tr>
                                                <th>@lang('Total Contacts')</th>
                                                <td class="total-count">0</td>
                                            </tr>
                                            <tr>
                                                <th>@lang('Created')</th>
                                                <td class="created-count">0</td>
                                            </tr>
                                            <tr>
                                                <th>@lang('Updated')</th>
                                                <td class="updated-count">0</td>
                                            </tr>
                                            <tr>
                                                <th>@lang('Skipped')</th>
                                                <td class="skipped-count">0</td>
                                            </tr>
                                            <tr>
                                                <th>@lang('Failed')</th>
                                                <td class="failed-count">0</td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="box box-solid">
                            <div class="box-header with-border">
                                <h3 class="box-title">@lang('Warehouses Synchronization')</h3>
                            </div>
                            <div class="box-body">
                                <form action="{{ route('sap.sync.warehouses') }}" method="POST" id="sync-warehouses-form">
                                    @csrf
                                    <button type="submit" class="btn btn-primary">@lang('Sync Warehouses from SAP')</button>
                                </form>
                                <div class="sync-status" id="warehouses-sync-status" style="display: none;">
                                    <hr>
                                    <div class="alert alert-info sync-message">
                                        <i class="fa fa-spinner fa-spin"></i> @lang('Syncing warehouses...')
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="box box-solid">
                            <div class="box-header with-border">
                                <h3 class="box-title">@lang('UoM Groups Synchronization')</h3>
                            </div>
                            <div class="box-body">
                                <form action="{{ route('sap.sync.uom-groups') }}" method="POST" id="sync-uom-groups-form">
                                    @csrf
                                    <button type="submit" class="btn btn-primary">@lang('Sync UoM Groups from SAP')</button>
                                </form>
                                <div class="sync-status" id="uom-groups-sync-status" style="display: none;">
                                    <hr>
                                    <div class="alert alert-info sync-message">
                                        <i class="fa fa-spinner fa-spin"></i> @lang('Syncing UoM groups...')
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endcomponent
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6">
            @component('components.widget', ['class' => 'box-primary', 'title' => __('Warehouse Mappings')])
                <table class="table table-bordered table-striped" id="warehouse-mappings-table">
                    <thead>
                        <tr>
                            <th>@lang('SAP Warehouse Code')</th>
                            <th>@lang('SAP Warehouse Name')</th>
                            <th>@lang('POS Business Location')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($warehouseMappings as $mapping)
                        <tr>
                            <td>{{ $mapping->warehouse_code }}</td>
                            <td>{{ $mapping->warehouse_name }}</td>
                            <td>
                                <select class="form-control location-select" name="mappings[{{ $mapping->warehouse_code }}]" data-warehouse-code="{{ $mapping->warehouse_code }}">
                                    <option value="">@lang('None')</option>
                                    @foreach($businessLocations as $id => $name)
                                        <option value="{{ $id }}" {{ $mapping->location_id == $id ? 'selected' : '' }}>{{ $name }}</option>
                                    @endforeach
                                </select>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                <button class="btn btn-primary" id="save-warehouse-mappings">@lang('Save Warehouse Mappings')</button>
            @endcomponent
        </div>
        
        <div class="col-md-6">
            @component('components.widget', ['class' => 'box-primary', 'title' => __('UoM Mappings')])
                <table class="table table-bordered table-striped" id="uom-mappings-table">
                    <thead>
                        <tr>
                            <th>@lang('SAP UoM Code')</th>
                            <th>@lang('SAP UoM Name')</th>
                            <th>@lang('POS Unit')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($uomMappings as $mapping)
                        <tr>
                            <td>{{ $mapping->uom_code }}</td>
                            <td>{{ $mapping->uom_name }}</td>
                            <td>
                                <select class="form-control unit-select" name="mappings[{{ $mapping->id }}]" data-uom-id="{{ $mapping->id }}">
                                    <option value="">@lang('None')</option>
                                    @foreach($units as $id => $name)
                                        <option value="{{ $id }}" {{ $mapping->unit_id == $id ? 'selected' : '' }}>{{ $name }}</option>
                                    @endforeach
                                </select>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                <button class="btn btn-primary" id="save-uom-mappings">@lang('Save UoM Mappings')</button>
            @endcomponent
        </div>
    </div>
</section>
@stop

@section('javascript')
<script>
    $(document).ready(function() {
        // Products sync
        $('#sync-products-form').submit(function(e) {
            e.preventDefault();
            let form = $(this);
            let url = form.attr('action');
            let fullSync = form.find('input[name="full_sync"]').is(':checked') ? 1 : 0;
            
            $('#products-sync-status').show();
            $('.sync-results', '#products-sync-status').hide();
            
            $.ajax({
                url: url,
                type: 'POST',
                data: { full_sync: fullSync, _token: '{{ csrf_token() }}' },
                success: function(response) {
                    if (response.success) {
                        $('.sync-message', '#products-sync-status').removeClass('alert-info alert-danger').addClass('alert-success').html('<i class="fa fa-check"></i> ' + response.message);
                        $('.sync-results', '#products-sync-status').show();
                        $('.total-count', '#products-sync-status').text(response.data.total);
                        $('.created-count', '#products-sync-status').text(response.data.created);
                        $('.updated-count', '#products-sync-status').text(response.data.updated);
                        $('.skipped-count', '#products-sync-status').text(response.data.skipped);
                        $('.failed-count', '#products-sync-status').text(response.data.failed);
                    } else {
                        $('.sync-message', '#products-sync-status').removeClass('alert-info alert-success').addClass('alert-danger').text(response.message);
                    }
                },
                error: function(xhr) {
                    $('.sync-message', '#products-sync-status').removeClass('alert-info alert-success').addClass('alert-danger').text('Error: ' + (xhr.responseJSON ? xhr.responseJSON.message : 'Unknown error'));
                }
            });
        });
        
        // Contacts sync
        $('#sync-contacts-form').submit(function(e) {
            e.preventDefault();
            let form = $(this);
            let url = form.attr('action');
            let fullSync = form.find('input[name="full_sync"]').is(':checked') ? 1 : 0;
            
            $('#contacts-sync-status').show();
            $('.sync-results', '#contacts-sync-status').hide();
            
            $.ajax({
                url: url,
                type: 'POST',
                data: { full_sync: fullSync, _token: '{{ csrf_token() }}' },
                success: function(response) {
                    if (response.success) {
                        $('.sync-message', '#contacts-sync-status').removeClass('alert-info alert-danger').addClass('alert-success').html('<i class="fa fa-check"></i> ' + response.message);
                        $('.sync-results', '#contacts-sync-status').show();
                        $('.total-count', '#contacts-sync-status').text(response.data.total);
                        $('.created-count', '#contacts-sync-status').text(response.data.created);
                        $('.updated-count', '#contacts-sync-status').text(response.data.updated);
                        $('.skipped-count', '#contacts-sync-status').text(response.data.skipped);
                        $('.failed-count', '#contacts-sync-status').text(response.data.failed);
                    } else {
                        $('.sync-message', '#contacts-sync-status').removeClass('alert-info alert-success').addClass('alert-danger').text(response.message);
                    }
                },
                error: function(xhr) {
                    $('.sync-message', '#contacts-sync-status').removeClass('alert-info alert-success').addClass('alert-danger').text('Error: ' + (xhr.responseJSON ? xhr.responseJSON.message : 'Unknown error'));
                }
            });
        });
        
        // Warehouses sync
        $('#sync-warehouses-form').submit(function(e) {
            e.preventDefault();
            let form = $(this);
            let url = form.attr('action');
            
            $('#warehouses-sync-status').show();
            
            $.ajax({
                url: url,
                type: 'POST',
                data: { _token: '{{ csrf_token() }}' },
                success: function(response) {
                    if (response.success) {
                        $('.sync-message', '#warehouses-sync-status').removeClass('alert-info alert-danger').addClass('alert-success').html('<i class="fa fa-check"></i> ' + response.message);
                        // Reload page to show new warehouse mappings
                        setTimeout(function() {
                            window.location.reload();
                        }, 2000);
                    } else {
                        $('.sync-message', '#warehouses-sync-status').removeClass('alert-info alert-success').addClass('alert-danger').text(response.message);
                    }
                },
                error: function(xhr) {
                    $('.sync-message', '#warehouses-sync-status').removeClass('alert-info alert-success').addClass('alert-danger').text('Error: ' + (xhr.responseJSON ? xhr.responseJSON.message : 'Unknown error'));
                }
            });
        });
        
        // UoM Groups sync
        $('#sync-uom-groups-form').submit(function(e) {
            e.preventDefault();
            let form = $(this);
            let url = form.attr('action');
            
            $('#uom-groups-sync-status').show();
            
            $.ajax({
                url: url,
                type: 'POST',
                data: { _token: '{{ csrf_token() }}' },
                success: function(response) {
                    if (response.success) {
                        $('.sync-message', '#uom-groups-sync-status').removeClass('alert-info alert-danger').addClass('alert-success').html('<i class="fa fa-check"></i> ' + response.message);
                        // Reload page to show new UoM mappings
                        setTimeout(function() {
                            window.location.reload();
                        }, 2000);
                    } else {
                        $('.sync-message', '#uom-groups-sync-status').removeClass('alert-info alert-success').addClass('alert-danger').text(response.message);
                    }
                },
                error: function(xhr) {
                    $('.sync-message', '#uom-groups-sync-status').removeClass('alert-info alert-success').addClass('alert-danger').text('Error: ' + (xhr.responseJSON ? xhr.responseJSON.message : 'Unknown error'));
                }
            });
        });
        
        // Save warehouse mappings
        $('#save-warehouse-mappings').click(function() {
            let mappings = {};
            
            $('.location-select').each(function() {
                let warehouseCode = $(this).data('warehouse-code');
                let locationId = $(this).val();
                mappings[warehouseCode] = locationId;
            });
            
            $.ajax({
                url: '{{ route("sap.map.warehouses") }}',
                type: 'POST',
                data: { 
                    mappings: mappings, 
                    _token: '{{ csrf_token() }}' 
                },
                success: function(response) {
                    if (response.success) {
                        toastr.success(response.message);
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function(xhr) {
                    toastr.error('Error: ' + (xhr.responseJSON ? xhr.responseJSON.message : 'Unknown error'));
                }
            });
        });
        
        // Save UoM mappings
        $('#save-uom-mappings').click(function() {
            let mappings = {};
            
            $('.unit-select').each(function() {
                let uomId = $(this).data('uom-id');
                let unitId = $(this).val();
                mappings[uomId] = unitId;
            });
            
            $.ajax({
                url: '{{ route("sap.map.uoms") }}',
                type: 'POST',
                data: { 
                    mappings: mappings, 
                    _token: '{{ csrf_token() }}' 
                },
                success: function(response) {
                    if (response.success) {
                        toastr.success(response.message);
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function(xhr) {
                    toastr.error('Error: ' + (xhr.responseJSON ? xhr.responseJSON.message : 'Unknown error'));
                }
            });
        });
    });
</script>
@endsection