<link href="https://fonts.googleapis.com/css2?family=Almarai:wght@300;400;700;800&display=swap" rel="stylesheet">

<style type="text/css">
    /* Reset all styles to prevent system CSS interference */
    .invoice-wrapper * {
        all: unset !important;
        display: revert !important;
        box-sizing: border-box !important;
    }
    
    /* Page settings */
    @page {
     
      
    }
    
    /* Base styles with !important */
    .invoice-wrapper {
        font-family: 'Almarai', Arial, sans-serif !important;
        color: #2c3e50 !important;
        direction: rtl !important;
        font-size: 14px !important;
        line-height: 1.3 !important;
        background-color: white !important;
        width: 100% !important;
      
        margin: 0 auto !important;
        padding: 10mm !important;
    }
    
    .invoice-wrapper table {
        width: 100% !important;
        border-collapse: collapse !important;
        border-spacing: 0 !important;
    }
    
    .invoice-wrapper td, .invoice-wrapper th {
        vertical-align: top !important;
        padding: 0 !important;
    }
    
    /* Header styles */
    .invoice-wrapper .header-section {
        background: linear-gradient(135deg, #00a99d 0%, #00c9b7 100%) !important;
        color: white !important;
        padding: 8px 15px !important;
        border-radius: 8px !important;
        margin-bottom: 10px !important;
        width: 100% !important;
    }
    
    .invoice-wrapper .header-section h1 {
        font-size: 20px !important;
        margin: 0 !important;
        color: white !important;
        font-weight: 800 !important;
        text-align: center !important;
    }
    
    .invoice-wrapper .header-section p {
        margin: 0 !important;
        font-size: 12px !important;
        color: white !important;
        text-align: center !important;
    }
    
    .invoice-wrapper .header-section img {
        max-height: 40px !important;
        width: auto !important;
        filter: brightness(0) invert(1) !important;
    }
    
    /* Info boxes */
    .invoice-wrapper .info-box {
        background-color: #f8f9fa !important;
        border: 1px solid #e9ecef !important;
        border-radius: 5px !important;
        padding: 5px 8px !important;
        margin: 2px !important;
        text-align: center !important;
        display: inline-block !important;
        width: calc(100% - 4px) !important;
    }
    
    .invoice-wrapper .info-box .label {
        font-size: 9px !important;
        color: #6c757d !important;
        display: block !important;
        margin-bottom: 2px !important;
    }
    
    .invoice-wrapper .info-box .value {
        font-size: 11px !important;
        font-weight: 600 !important;
        color: #2c3e50 !important;
        display: block !important;
    }
    
    .invoice-wrapper .info-box.danger {
        background-color: #f8d7da !important;
        border-color: #f5c6cb !important;
    }
    
    .invoice-wrapper .info-box.danger .value {
        color: #dc3545 !important;
    }
    
    .invoice-wrapper .info-box.success {
        background-color: #d4edda !important;
        border-color: #c3e6cb !important;
    }
    
    .invoice-wrapper .info-box.success .value {
        color: #28a745 !important;
    }
    
    /* Info cards */
    .invoice-wrapper .info-card {
        background-color: #f8f9fa !important;
        border-radius: 6px !important;
        padding: 8px !important;
        border-right: 3px solid #00a99d !important;
        margin-bottom: 8px !important;
        width: 100% !important;
    }
    
    .invoice-wrapper .info-card h4 {
        color: #00a99d !important;
        font-size: 12px !important;
        margin: 0 0 5px 0 !important;
        font-weight: 700 !important;
    }
    
    .invoice-wrapper .info-card p {
        margin: 2px 0 !important;
        font-size: 12px !important;
        color: #2c3e50 !important;
    }
    
    .invoice-wrapper .info-card strong {
        font-weight: 600 !important;
        color: #495057 !important;
    }
    
    /* Products table */
    .invoice-wrapper .products-table {
        width: 100% !important;
        border-collapse: separate !important;
        border-spacing: 0 !important;
        margin: 10px 0 !important;
        font-size: 12px !important;
        overflow: hidden !important;
        border-radius: 8px !important;
    }
    
    .invoice-wrapper .products-table thead tr {
        background: linear-gradient(135deg, #00a99d 0%, #00c9b7 100%) !important;
    }
    
    .invoice-wrapper .products-table th {
        color: white !important;
        padding: 5px 3px !important;
        font-weight: 600 !important;
        font-size: 12px !important;
        text-align: center !important;
        border: none !important;
    }
    
    .invoice-wrapper .products-table th:first-child {
        border-top-right-radius: 8px !important;
    }
    
    .invoice-wrapper .products-table th:last-child {
        border-top-left-radius: 8px !important;
    }
    
    .invoice-wrapper .products-table td {
        padding: 4px 3px !important;
        border-bottom: 1px solid #e9ecef !important;
        font-size: 12px !important;
        color: #2c3e50 !important;
        text-align: center !important;
    }
    
    .invoice-wrapper .products-table tbody tr:nth-child(even) {
        background-color: #f8f9fa !important;
    }
    
    .invoice-wrapper .products-table td:first-child {
        font-weight: 600 !important;
        color: #00a99d !important;
    }
    
    .invoice-wrapper .products-table td:nth-child(2) {
        text-align: right !important;
        padding-right: 8px !important;
    }
    
    .invoice-wrapper .products-table td:nth-child(2) strong {
        font-weight: 600 !important;
        color: #2c3e50 !important;
    }
    
    .invoice-wrapper .products-table td:last-child {
        font-weight: 600 !important;
        background-color: #e7f6f5 !important;
    }
    
    /* Summary box */
    .invoice-wrapper .summary-box {
        background-color: #f8f9fa !important;
        border-radius: 6px !important;
        padding: 8px !important;
        font-size: 12px !important;
        width: 100% !important;
    }
    
    .invoice-wrapper .summary-box h5 {
        font-size: 11px !important;
        color: #00a99d !important;
        margin: 0 0 5px 0 !important;
        font-weight: 600 !important;
    }
    
    .invoice-wrapper .summary-row {
        display: flex !important;
        justify-content: space-between !important;
        padding: 3px 0 !important;
        border-bottom: 1px solid #e9ecef !important;
        align-items: center !important;
    }
    
    .invoice-wrapper .summary-row span {
        font-size: 12px !important;
        color: #2c3e50 !important;
    }
    
    .invoice-wrapper .summary-row span:last-child {
        font-weight: 600 !important;
    }
    
    .invoice-wrapper .total-box {
        background: linear-gradient(135deg, #00a99d 0%, #00c9b7 100%) !important;
        color: white !important;
        padding: 8px !important;
        border-radius: 5px !important;
        margin-top: 5px !important;
        font-size: 14px !important;
        font-weight: 700 !important;
        text-align: center !important;
    }
    
    /* Footer */
    .invoice-wrapper .footer-section {
        background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%) !important;
        color: white !important;
        padding: 15px !important;
        border-radius: 8px !important;
        margin-top: 20px !important;
        font-size: 12px !important;
    }
    
    .invoice-wrapper .footer-info {
        display: flex !important;
        justify-content: space-between !important;
        flex-wrap: wrap !important;
        gap: 10px !important;
    }
    
    .invoice-wrapper .footer-item {
        flex: 1 !important;
        min-width: 150px !important;
        text-align: center !important;
    }
    
    .invoice-wrapper .footer-item span {
        color: white !important;
        display: block !important;
        margin: 2px 0 !important;
    }
    
    /* Badge */
    .invoice-wrapper .badge {
        display: inline-block !important;
        padding: 2px 6px !important;
        border-radius: 10px !important;
        font-size: 8px !important;
        font-weight: 600 !important;
        background-color: #e9ecef !important;
        color: #495057 !important;
        margin-right: 5px !important;
    }
    
    /* Signature */
    .invoice-wrapper .signature-box {
        border-top: 1px solid #333 !important;
        width: 120px !important;
        margin: 20px auto 5px !important;
        padding-top: 5px !important;
        text-align: center !important;
    }
    
    .invoice-wrapper .signature-box small {
        font-size: 12px !important;
        color: #6c757d !important;
    }
    
    /* Currency exchange box */
    .invoice-wrapper .exchange-rate-box {
        background-color: #e3f2fd !important;
        border: 1px solid #90caf9 !important;
        border-radius: 5px !important;
        padding: 5px !important;
        margin: 5px 0 !important;
        font-size: 9px !important;
        text-align: center !important;
    }
    
    /* Print styles */
    @media print {
        .invoice-wrapper {
            margin: 0 !important;
            padding: 0 !important;
            page-break-after: avoid !important;
        }
        
        .invoice-wrapper * {
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        }
    }
</style>

<div class="invoice-wrapper">
    <!-- PHP Variables to check if there are any discounts and currency conversion -->
    <?php
        $hasDiscount = false;
        $hasLineDiscount = false;
        
        // Currency conversion settings
        $exchangeRate = isset($receipt_details->exchange_rate) ? $receipt_details->exchange_rate : 1410;
        $showOriginalCurrency = isset($receipt_details->show_original_currency) ? $receipt_details->show_original_currency : false;
        $currencySymbol = isset($receipt_details->currency_symbol) ? $receipt_details->currency_symbol : '$';
        $iqd_symbol = ' دينار عراقي';
        
        // Function to convert price to IQD
        function convertToIQD($price, $rate) {
            $cleanPrice = preg_replace('/[^0-9.]/', '', $price);
            return number_format(floatval($cleanPrice) * $rate, 0, '.', ',');
        }
        
        // Function to format price display for table (USD only without symbol)
        function formatTablePrice($originalPrice) {
            $cleanPrice = preg_replace('/[^0-9.]/', '', $originalPrice);
            return number_format(floatval($cleanPrice), 2, '.', ',');
        }
        
        // Function to format total price display (USD without symbol + IQD with symbol)
        function formatTotalDisplay($originalPrice, $rate, $iqd_symbol) {
            $cleanPrice = preg_replace('/[^0-9.]/', '', $originalPrice);
            $iqd_price = convertToIQD($originalPrice, $rate);
            
            return '<span style="display: block !important; font-size: 14px !important;"> ' . $iqd_price . '' . $iqd_symbol . '</span>';
        }
        
        // Check if there's a general discount
        if (!empty($receipt_details->discount) && $receipt_details->discount != '0.00') {
            $hasDiscount = true;
        }
        
        // Check if there's a total line discount
        if (!empty($receipt_details->total_line_discount) && $receipt_details->total_line_discount != '0.00') {
            $hasLineDiscount = true;
        }
        
        // Check if any line has discount
        if (isset($receipt_details->lines) && is_array($receipt_details->lines)) {
            foreach($receipt_details->lines as $line) {
                if (!empty($line['total_line_discount']) && $line['total_line_discount'] != '0.00') {
                    $hasLineDiscount = true;
                    break;
                }
            }
        }
        
        $showDiscountColumns = $hasDiscount || $hasLineDiscount;
    ?>
    
    <table>
        <!-- Header Section -->
        <tr>
            <td>
                <div class="header-section">
                    <table>
                        <tr>
                            <td style="width: 25% !important;">
                                <?php if(!empty($receipt_details->logo)): ?>
                                    <img src="<?php echo e($receipt_details->logo, false); ?>" alt="logo">
                                <?php endif; ?>
                            </td>
                            <td style="width: 50% !important; text-align: center !important;">
                                <h1>
                                    <?php if(!empty($receipt_details->invoice_heading)): ?>
                                        <?php echo $receipt_details->invoice_heading; ?>

                                    <?php else: ?>
                                        فاتورة مبيعات
                                    <?php endif; ?>
                                </h1>
                                <?php if(!empty($receipt_details->display_name)): ?>
                                    <p><?php echo e($receipt_details->display_name, false); ?></p>
                                <?php endif; ?>
                            </td>
                            <td style="width: 25% !important; text-align: left !important;">
                                <div style="background-color: rgba(255,255,255,0.2) !important; padding: 5px !important; border-radius: 5px !important; display: inline-block !important;">
                                    <span style="font-size: 9px !important; color: white !important; display: block !important;">رقم الفاتورة</span>
                                    <strong style="font-size: 14px !important; color: white !important; display: block !important;">
                                        <?php if(!empty($receipt_details->invoice_no_prefix)): ?>
                                            <?php echo $receipt_details->invoice_no_prefix; ?>

                                        <?php endif; ?>
                                        <?php echo e($receipt_details->invoice_no, false); ?>

                                    </strong>
                                </div>
                            </td>
                        </tr>
                    </table>
                </div>
            </td>
        </tr>
        
        <!-- Exchange Rate Info -->
        <?php if($showOriginalCurrency): ?>
        <tr>
            <td>
                <div class="exchange-rate-box">
                    <strong>سعر الصرف:</strong> 1 <?php echo e($currencySymbol, false); ?> = <?php echo e(number_format($exchangeRate, 0, '.', ','), false); ?> <?php echo e($iqd_symbol, false); ?>

                </div>
            </td>
        </tr>
        <?php endif; ?>
        
        <!-- Invoice Details -->
        <tr>
            <td>
                <table style="margin-bottom: 8px !important;">
                    <tr>
                        <td style="width: 20% !important; padding: 0 2px !important;">
                            <div class="info-box">
                                <span class="label">التاريخ</span>
                                <span class="value"><?php echo e($receipt_details->invoice_date ?? date('Y-m-d'), false); ?></span>
                            </div>
                        </td>
                        <td style="width: 20% !important; padding: 0 2px !important;">
                            <div class="info-box">
                                <span class="label">الاستحقاق</span>
                                <span class="value"><?php echo e($receipt_details->due_date ?? date('Y-m-d', strtotime('+30 days')), false); ?></span>
                            </div>
                        </td>
                        <td style="width: 20% !important; padding: 0 2px !important;">
                            <div class="info-box">
                                <span class="label">طريقة الدفع</span>
                                <span class="value"><?php echo e(isset($receipt_details->payments[0]['method']) ? $receipt_details->payments[0]['method'] : 'نقدي', false); ?></span>
                            </div>
                        </td>
                        <?php if(!empty($receipt_details->total_due) && $receipt_details->total_due != '0.00'): ?>
                        <td style="width: 20% !important; padding: 0 2px !important;">
                            <div class="info-box danger">
                                <span class="label">المستحق</span>
                                <span class="value"><?php echo e($iqd_symbol, false); ?> <?php echo e(convertToIQD($receipt_details->total_due, $exchangeRate), false); ?></span>
                            </div>
                        </td>
                        <?php endif; ?>
                        <?php if(!empty($receipt_details->total_paid) && $receipt_details->total_paid != '0.00'): ?>
                        <td style="width: 20% !important; padding: 0 2px !important;">
                            <div class="info-box success">
                                <span class="label">المدفوع</span>
                                <span class="value"><?php echo e($iqd_symbol, false); ?> <?php echo e(convertToIQD($receipt_details->total_paid, $exchangeRate), false); ?></span>
                            </div>
                        </td>
                        <?php endif; ?>
                    </tr>
                </table>
            </td>
        </tr>
        
        <!-- Customer Info Only -->
        <tr>
            <td>
                <table style="margin-bottom: 8px !important;">
                    <tr>
                        <td style="width: 100% !important; vertical-align: top !important;">
                            <div class="info-card">
                                <h4>معلومات العميل</h4>
                                <?php if(!empty($receipt_details->customer_info)): ?>
                                    <p><strong>الاسم:</strong> <?php echo strip_tags($receipt_details->customer_info); ?></p>
                                <?php else: ?>
                                    <p><strong>الاسم:</strong> عميل نقدي</p>
                                <?php endif; ?>
                                <?php if(!empty($receipt_details->client_id)): ?>
                                    <p><strong>الرقم:</strong> <?php echo e($receipt_details->client_id, false); ?></p>
                                <?php endif; ?>
                                <?php if(!empty($receipt_details->sales_person)): ?>
                                    <p><strong>المندوب:</strong> <?php echo e($receipt_details->sales_person, false); ?></p>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        
        <!-- Products Table -->
        <tr>
            <td>
                <table class="products-table">
                    <thead>
                        <tr>
                            <th style="width: <?php echo e($showDiscountColumns ? '4%' : '5%', false); ?> !important;">#</th>
                            <th style="width: <?php echo e($showDiscountColumns ? '35%' : '45%', false); ?> !important;">الصنف</th>
                            <th style="width: <?php echo e($showDiscountColumns ? '8%' : '10%', false); ?> !important;">الكمية</th>
                            <th style="width: <?php echo e($showDiscountColumns ? '8%' : '10%', false); ?> !important;">الوحدة</th>
                            <th style="width: <?php echo e($showDiscountColumns ? '10%' : '15%', false); ?> !important;">السعر</th>
                            <?php if($showDiscountColumns): ?>
                                <th style="width: 10% !important;">الخصم</th>
                                <th style="width: 10% !important;">بعد الخصم</th>
                            <?php endif; ?>
                            <th style="width: <?php echo e($showDiscountColumns ? '15%' : '15%', false); ?> !important;">الإجمالي</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $rowCount = 0; ?>
                        <?php if(isset($receipt_details->lines) && is_array($receipt_details->lines)): ?>
                            <?php $__empty_1 = true; $__currentLoopData = $receipt_details->lines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $line): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($loop->iteration, false); ?></td>
                                <td>
                                    <strong><?php echo e($line['name'] ?? '', false); ?></strong>
                                     <?php if(!empty($line['product_custom_field1'])): ?>
                    <span style="font-size: 9px !important; color: #6c757d !important;"> - <?php echo e($line['product_custom_field1'], false); ?></span>
                <?php endif; ?>
                                    <?php if(!empty($line['variation'])): ?>
                                        <span style="font-size: 9px !important; color: #6c757d !important;"> - <?php echo e($line['variation'], false); ?></span>
                                    <?php endif; ?>
                                    <?php if(!empty($line['brand'])): ?>
                                        <span class="badge"><?php echo e($line['brand'], false); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td><strong><?php echo e($line['quantity'] ?? '1', false); ?></strong></td>
                                <td><?php echo e($line['units'] ?? '', false); ?></td>
                                <td><?php echo e(formatTablePrice($line['unit_price_before_discount'] ?? $line['unit_price_inc_tax'] ?? '0'), false); ?></td>
                                <?php if($showDiscountColumns): ?>
                                    <td>
                                        <?php if(!empty($line['total_line_discount']) && $line['total_line_discount'] != '0.00'): ?>
                                            <?php echo e(formatTablePrice($line['total_line_discount']), false); ?>

                                            <?php if(!empty($line['line_discount_percent'])): ?>
                                                <small style="font-size: 8px !important; display: block !important;">(<?php echo e($line['line_discount_percent'], false); ?>%)</small>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            -
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e(formatTablePrice($line['unit_price_exc_tax'] ?? $line['unit_price_inc_tax'] ?? '0'), false); ?></td>
                                <?php endif; ?>
                                <td><?php echo e(formatTablePrice($line['line_total'] ?? '0'), false); ?></td>
                            </tr>
                            <?php $rowCount++; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="<?php echo e($showDiscountColumns ? '8' : '6', false); ?>" style="text-align: center !important; padding: 10px !important;">لا توجد منتجات</td>
                            </tr>
                            <?php endif; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="<?php echo e($showDiscountColumns ? '8' : '6', false); ?>" style="text-align: center !important; padding: 10px !important;">لا توجد منتجات</td>
                            </tr>
                        <?php endif; ?>
                        
                        <?php for($i = $rowCount; $i < 10; $i++): ?>
                        <tr>
                            <td style="padding: 6px !important; color: #f8f9fa !important;"><?php echo e($i + 1, false); ?></td>
                            <td>&nbsp;</td>
                            <td>&nbsp;</td>
                            <td>&nbsp;</td>
                            <td>&nbsp;</td>
                            <?php if($showDiscountColumns): ?>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                            <?php endif; ?>
                            <td style="background-color: #f8f9fa !important;">&nbsp;</td>
                        </tr>
                        <?php endfor; ?>
                    </tbody>
                </table>
            </td>
        </tr>
        
        <!-- Summary Section -->
        <tr>
            <td>
                <table style="margin-top: 10px !important;">
                    <tr>
                        <td style="width: 55% !important; vertical-align: top !important; padding-left: 10px !important;">
                            <?php if(!empty($receipt_details->payments) && is_array($receipt_details->payments)): ?>
                            <div class="summary-box" style="margin-bottom: 8px !important;">
                                <h5>المدفوعات</h5>
                                <table style="font-size: 10px !important;">
                                    <?php $__currentLoopData = $receipt_details->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td style="padding: 2px 5px !important;"><?php echo e($payment['method'] ?? '', false); ?></td>
                                        <td style="padding: 2px 5px !important; text-align: center !important;"><?php echo e($iqd_symbol, false); ?> <?php echo e(convertToIQD($payment['amount'] ?? '0', $exchangeRate), false); ?></td>
                                        <td style="padding: 2px 5px !important; text-align: center !important;"><?php echo e($payment['date'] ?? '', false); ?></td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </table>
                            </div>
                            <?php endif; ?>
                            
                            <?php if(!empty($receipt_details->additional_notes)): ?>
                            <div class="summary-box" style="background-color: #fff3cd !important;">
                                <h5 style="color: #856404 !important;">ملاحظات</h5>
                                <p style="margin: 0 !important; font-size: 12px !important;"><?php echo nl2br($receipt_details->additional_notes); ?></p>
                            </div>
                            <?php endif; ?>
                        </td>
                        <td style="width: 45% !important; vertical-align: top !important; padding-right: 10px !important;">
                            <div class="summary-box">
                                <div class="summary-row">
                                  
                                    <span><?php echo e(formatTablePrice($receipt_details->subtotal ?? '0'), false); ?></span>
                                </div>
                                
                                <?php if(!empty($receipt_details->discount) && $receipt_details->discount != '0.00'): ?>
                                <div class="summary-row">
                                    <span style="color: #dc3545 !important;">الخصم</span>
                                    <span style="color: #dc3545 !important;">(-) <?php echo e(formatTablePrice($receipt_details->discount), false); ?></span>
                                </div>
                                <?php endif; ?>
                                
                                <?php if(!empty($receipt_details->total_line_discount) && $receipt_details->total_line_discount != '0.00'): ?>
                                <div class="summary-row">
                                    <span style="color: #dc3545 !important;">خصم الأصناف</span>
                                    <span style="color: #dc3545 !important;">(-) <?php echo e(formatTablePrice($receipt_details->total_line_discount), false); ?></span>
                                </div>
                                <?php endif; ?>
                                
                                <?php if(!empty($receipt_details->shipping_charges) && $receipt_details->shipping_charges != '0.00'): ?>
                                <div class="summary-row">
                                    <span>الشحن</span>
                                    <span>(+) <?php echo e(formatTablePrice($receipt_details->shipping_charges), false); ?></span>
                                </div>
                                <?php endif; ?>
                                
                                <div class="total-box">
                                    <?php echo e($receipt_details->total_label ?? 'الإجمالي', false); ?>: <?php echo formatTotalDisplay($receipt_details->total ?? '0', $exchangeRate, $iqd_symbol); ?>

                                </div>
                                
                                <?php if(!empty($receipt_details->total_in_words)): ?>
                                <p style="text-align: center !important; margin-top: 5px !important; font-size: 9px !important; color: #6c757d !important;">
                                    <?php echo e($receipt_details->total_in_words, false); ?>

                                </p>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        
        <!-- Signature -->
        <tr>
            <td>
                <table style="margin-top: 10px !important;">
                    <tr>
                        <td style="width: 40% !important;">
                            <?php if(!empty($receipt_details->show_barcode) || !empty($receipt_details->show_qr_code)): ?>
                                <div style="text-align: center !important;">
                                    <?php if(!empty($receipt_details->show_barcode) && class_exists('DNS1D')): ?>
                                        <img src="data:image/png;base64,<?php echo e(DNS1D::getBarcodePNG($receipt_details->invoice_no, 'C128', 1, 25, [39, 48, 54], true), false); ?>" style="max-width: 150px !important;">
                                    <?php endif; ?>
                                    <?php if(!empty($receipt_details->show_qr_code) && !empty($receipt_details->qr_code_text) && class_exists('DNS2D')): ?>
                                        <img src="data:image/png;base64,<?php echo e(DNS2D::getBarcodePNG($receipt_details->qr_code_text, 'QRCODE', 2, 2, [39, 48, 54]), false); ?>" style="max-width: 60px !important; margin-right: 10px !important;">
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </td>
                        <td style="width: 30% !important; text-align: center !important;">
                            <div class="signature-box">
                                <small>التوقيع المعتمد</small>
                            </div>
                        </td>
                        <td style="width: 30% !important; text-align: center !important;">
                            <div class="signature-box">
                                <small>توقيع العميل</small>
                            </div>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        
        <!-- Company Info Footer -->
        <tr>
    <td>
        <div class="footer-section">
            <div style="display: flex !important; justify-content: space-between !important; align-items: flex-start !important;">
                <!-- Addresses on the right (Arabic RTL) -->
                <div style="text-align: right !important; flex: 1 !important; direction: rtl !important;">
                    <span style="display: block !important; margin-bottom: 3px !important; font-size: 12px !important;">📍 بغداد - الصرافية - مقابل جامع عادلة خاتون</span>
                    <span style="display: block !important; font-size: 12px !important;">📍 بغداد - الشورجة - خان حميد النجار</span>
                </div>
                
                <!-- Phone numbers in center -->
                <div style="text-align: center !important; flex: 1 !important;">
                    <span style="display: block !important; margin-bottom: 3px !important;">📞 07700004462</span>
                    <span style="display: block !important;">📞  07902406969</span>
                </div>
                
                <!-- Email and Website on the left -->
                <div style="text-align: left !important; flex: 1 !important;">
                    <span style="display: block !important; margin-bottom: 3px !important;">✉️ nbsiqofficial@gmail.com</span>
                    <span style="display: block !important;">🌐 nbs.iq</span>
                </div>
            </div>
        </div>
    </td>
</tr>
    </table>
</div><?php /**PATH C:\xampp\htdocs\comboss\as\resources\views/sale_pos/receipts/detailed.blade.php ENDPATH**/ ?>