<?php
    $is_mobile = isMobile();
?>
<!-- حاوية مدمجة بارتفاع 70px - متوازنة -->
<div class="compact-form-container" style="max-height: 70px; border-radius: 8px; background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%); border: 1px solid #dee2e6; overflow: hidden;">
    <div class="row no-gutters" style="height: 70px; align-items: center; display: flex;">
        
        <!-- ملاحظات الموظف - 25% -->
        <div class="col-md-3" style="padding: 5px;">
            <div class="form-group mb-0">
                <?php echo Form::textarea('staff_note', 
                    !empty($transaction) ? $transaction->staff_note : null, [
                    'class' => 'form-control',
                    'rows' => 1,
                    'placeholder' => '👤 ملاحظات الموظف',
                    'style' => 'font-size: 14px; height: 50px; resize: none; border-radius: 6px; font-weight: 500; padding: 12px;'
                ]); ?>

            </div>
        </div>
        
        <!-- ملاحظات البيع - 25% -->
        <div class="col-md-3" style="padding: 5px;">
            <div class="form-group mb-0">
                <?php echo Form::textarea('sale_note', 
                    !empty($transaction) ? $transaction->additional_notes : null, [
                    'class' => 'form-control',
                    'rows' => 1,
                    'placeholder' => '📝 ملاحظات البيع',
                    'style' => 'font-size: 14px; height: 50px; resize: none; border-radius: 6px; font-weight: 500; padding: 12px;'
                ]); ?>

            </div>
        </div>

        <!-- نوع الفاتورة - 25% -->
        <div class="col-md-3" style="padding: 5px;">
            <div class="form-group mb-0">
                <?php echo Form::select('invoice_type', [
                    'شركات_توصيل' => __('شركات_توصيل'),
                    'دلفري' => __('دلفري'),
                    'نقليات' => __('نقليات'),
                    'الشورجة' => __('الشورجة'),
                    'زبون محل' => __('زبون_محل')
                ], null, [
                    'class' => 'form-control',
                    'placeholder' => '📄 نوع الفاتورة',
                    'style' => 'font-size: 14px; height: 50px; border-radius: 6px; font-weight: 500; padding: 0 12px; width: 100%;'
                ]); ?>

            </div>
        </div>

        <!-- الخصم - 25% -->
        <div class="col-md-3" style="padding: 5px;">
            <?php
                $is_discount_enabled = $pos_settings['disable_discount'] != 1 ? true : false;
                $is_rp_enabled = session('business.enable_rp') == 1 ? true : false;
                $edit_discount = !Gate::check('disable_edit_discount') || auth()->user()->can('superadmin') || auth()->user()->can('admin');
            ?>
            <?php if($is_discount_enabled || $is_rp_enabled): ?>
                <div class="form-group mb-0">
                    <?php if($edit_discount): ?>
                        <button type="button" 
                                class="btn btn-primary w-100" 
                                style="border: none; border-radius: 6px; padding: 0 15px; height: 50px; font-size: 14px; font-weight: 500; display: flex; align-items: center; justify-content: center;"
                                data-toggle="modal" 
                                data-target="#posEditDiscountModal" 
                                title="<?php echo app('translator')->get('sale.edit_discount'); ?>">
                            <i class="fas fa-percent" style="margin-left: 8px;"></i>
                            <span>الخصم</span>
                        </button>
                    <?php endif; ?>
                    <!-- Hidden fields for discount -->
                    <input type="hidden" name="discount_type" id="discount_type" 
                        value="<?php if(empty($edit)): ?><?php echo e('percentage', false); ?><?php else: ?><?php echo e($transaction->discount_type, false); ?><?php endif; ?>" 
                        data-default="percentage">
                    <input type="hidden" name="discount_amount" id="discount_amount" 
                        value="<?php if(empty($edit)): ?> <?php echo e(number_format($business_details->default_sales_discount, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?> <?php else: ?> <?php echo e(number_format($transaction->discount_amount, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?> <?php endif; ?>" 
                        data-default="<?php echo e($business_details->default_sales_discount, false); ?>">
                    <input type="hidden" name="rp_redeemed" id="rp_redeemed" 
                        value="<?php if(empty($edit)): ?><?php echo e('0', false); ?><?php else: ?><?php echo e($transaction->rp_redeemed, false); ?><?php endif; ?>">
                    <input type="hidden" name="rp_redeemed_amount" id="rp_redeemed_amount" 
                        value="<?php if(empty($edit)): ?><?php echo e('0', false); ?><?php else: ?> <?php echo e($transaction->rp_redeemed_amount, false); ?> <?php endif; ?>">
                </div>
            <?php endif; ?>
        </div>
        
    </div>
</div>

<style>
.compact-form-container {
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
}

.compact-form-container:hover {
    box-shadow: 0 4px 8px rgba(0,0,0,0.15);
}

/* تأكد من عدم وجود مسافات إضافية */
.compact-form-container .row {
    margin: 0 !important;
}

.compact-form-container [class*="col-"] {
    padding-left: 5px !important;
    padding-right: 5px !important;
}

/* العنصر الأول والأخير */
.compact-form-container [class*="col-"]:first-child {
    padding-right: 10px !important;
}

.compact-form-container [class*="col-"]:last-child {
    padding-left: 10px !important;
}

.compact-form-container .form-control:focus {
    border-color: #007bff;
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
}

.compact-form-container .btn-primary {
    background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
    transition: all 0.3s ease;
    border: 2px solid transparent;
}

.compact-form-container .btn-primary:hover {
    background: linear-gradient(135deg, #0056b3 0%, #003d82 100%);
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(0, 123, 255, 0.3);
}

.compact-form-container .form-control {
    transition: all 0.3s ease;
    border: 2px solid #e9ecef;
    background-color: #ffffff;
}

.compact-form-container .form-control:hover {
    border-color: #80bdff;
    background-color: #ffffff;
}

.compact-form-container .form-control::placeholder {
    color: #6c757d;
    font-weight: 500;
    opacity: 0.8;
}

/* تأكد من أن زر الخصم و select نوع الفاتورة لهما نفس الارتفاع */
.compact-form-container select.form-control,
.compact-form-container .btn-primary {
    height: 50px !important;
}

/* جعل جميع العناصر بنفس الارتفاع */
.compact-form-container .form-group {
    margin-bottom: 0 !important;
    height: 100%;
}

/* تحسينات للشاشات الصغيرة */
@media (max-width: 768px) {
    .compact-form-container {
        max-height: none;
        min-height: 70px;
    }
    
    .compact-form-container .row {
        height: auto;
        flex-wrap: wrap !important;
    }
    
    .compact-form-container [class*="col-"] {
        padding: 5px !important;
        width: 50% !important;
        max-width: 50% !important;
        flex: 0 0 50% !important;
    }
    
    /* في الشاشات الصغيرة جداً */
    @media (max-width: 576px) {
        .compact-form-container [class*="col-"] {
            width: 100% !important;
            max-width: 100% !important;
            flex: 0 0 100% !important;
        }
    }
    
    .compact-form-container .form-control,
    .compact-form-container .btn-primary {
        height: 45px !important;
        font-size: 13px !important;
    }
    
    .compact-form-container .form-control {
        padding: 10px !important;
    }
    
    .compact-form-container .btn-primary {
        padding: 0 12px !important;
    }
}

/* تحسينات RTL */
[dir="rtl"] .compact-form-container .btn-primary i {
    margin-left: 0;
    margin-right: 8px;
}

/* التأكد من عدم تجاوز العناصر للحاوية */
.compact-form-container * {
    box-sizing: border-box;
}
</style>

<div class="row">
    <div class="cyber-pos-actions-container">
        <!-- تأثير اللمعة المتحركة -->
        <div class="cyber-shimmer"></div>
       
        <!-- محتوى شريط الإجراءات -->
        <div class="cyber-actions-content">
            <!-- القسم الأول: المجموع -->
            <div class="cyber-section total-section">
                <div class="cyber-total-label"><?php echo app('translator')->get('sale.total_payable'); ?>:</div>
                <input type="hidden" name="final_total" id="final_total_input" value="0.00">
                <div class="cyber-total-amount">
                    <span class="currency-symbol">$</span>
                    <span id="total_payable" class="number">0.00</span>
                </div>
            </div>
            
            <!-- الفاصل -->
            <div class="cyber-divider"></div>
            
            <!-- القسم الثاني: أزرار العمليات الرئيسية -->
            <div class="cyber-section main-actions-section">
                <?php if(!Gate::check('disable_express_checkout') || auth()->user()->can('superadmin') || auth()->user()->can('admin')): ?>
                    <button type="button" class="cyber-btn cyber-btn-success pos-express-finalize <?php if($pos_settings['disable_express_checkout'] != 0 || !array_key_exists('cash', $payment_types)): ?> hide <?php endif; ?>"
                        data-pay_method="cash" title="<?php echo app('translator')->get('tooltip.express_checkout'); ?>">
                        <i class="fas fa-shopping-cart"></i>
                        <span>Sale Order</span>
                    </button>
                <?php endif; ?>

                <?php if(!Gate::check('disable_draft') || auth()->user()->can('superadmin') || auth()->user()->can('admin')): ?>
                    <button type="button" class="cyber-btn cyber-btn-info" id="pos-draft" <?php if(!empty($only_payment)): ?> disabled <?php endif; ?>>
                        <i class="fas fa-edit"></i>
                        <span><?php echo app('translator')->get('sale.draft'); ?></span>
                    </button>
                <?php endif; ?>

                <?php if(!Gate::check('disable_quotation') || auth()->user()->can('superadmin') || auth()->user()->can('admin')): ?>
                    <button type="button" class="cyber-btn cyber-btn-warning" id="pos-quotation" <?php if(!empty($only_payment)): ?> disabled <?php endif; ?>>
                        <i class="fas fa-file-alt"></i>
                        <span><?php echo app('translator')->get('lang_v1.quotation'); ?></span>
                    </button>
                <?php endif; ?>

                <?php if(!Gate::check('disable_suspend_sale') || auth()->user()->can('superadmin') || auth()->user()->can('admin')): ?>
                    <?php if(empty($pos_settings['disable_suspend'])): ?>
                        <button type="button" class="cyber-btn cyber-btn-orange"
                            data-pay_method="suspend" title="<?php echo app('translator')->get('lang_v1.tooltip_suspend'); ?>"
                            <?php if(!empty($only_payment)): ?> disabled <?php endif; ?>>
                            <i class="fas fa-pause"></i>
                            <span><?php echo app('translator')->get('lang_v1.suspend'); ?></span>
                        </button>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
            
            <!-- الفاصل -->
            <div class="cyber-divider"></div>
            
            <!-- القسم الثالث: أزرار الإجراءات الثانوية -->
            <div class="cyber-section secondary-actions-section">
                <?php if(empty($edit)): ?>
                    <button type="button" class="cyber-btn cyber-btn-danger" id="pos-cancel">
                        <i class="fas fa-times"></i>
                        <span><?php echo app('translator')->get('sale.cancel'); ?></span>
                    </button>
                <?php else: ?>
                    <button type="button" class="cyber-btn cyber-btn-danger" id="pos-delete" <?php if(!empty($only_payment)): ?> disabled <?php endif; ?>>
                        <i class="fas fa-trash-alt"></i>
                        <span><?php echo app('translator')->get('messages.delete'); ?></span>
                    </button>
                <?php endif; ?>

                <!-- WhatsApp Button -->
                <button type="button" class="cyber-btn cyber-btn-whatsapp" id="sendDirectToWhatsApp">
                    <i class="fab fa-whatsapp"></i>
                    <span>WhatsApp</span>
                    <span class="cyber-loading" style="display: none;">
                        <i class="fa fa-spinner fa-spin"></i>
                    </span>
                </button>

                <?php if(!isset($pos_settings['hide_recent_trans']) || $pos_settings['hide_recent_trans'] == 0): ?>
                    <button type="button" class="cyber-btn cyber-btn-primary"
                        data-toggle="modal" data-target="#recent_transactions_modal" id="recent-transactions">
                        <i class="fas fa-clock"></i>
                        <span><?php echo app('translator')->get('lang_v1.recent_transactions'); ?></span>
                    </button>
                <?php endif; ?>

            </div>
        </div>
    </div>
</div>

<style>
/* الحاوي الرئيسي */
.cyber-pos-actions-container {
    background: linear-gradient(135deg, #0f1419 0%, #1a1f2e 100%);
    border-radius: 12px 12px 0 0;
    padding: 10px 15px;
    position: relative;
    overflow: hidden;
    border: 1px solid rgba(56, 189, 248, 0.2);
    box-shadow: 0 -4px 24px rgba(0, 0, 0, 0.4), 
                inset 0 1px 0 rgba(255, 255, 255, 0.05);
    min-height: 60px;
}

/* تأثير اللمعة المتحركة */
.cyber-shimmer {
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, 
        transparent, 
        rgba(56, 189, 248, 0.1), 
        rgba(129, 140, 248, 0.1),
        transparent);
    animation: cyberShimmer 10s ease-in-out infinite;
    pointer-events: none;
}

@keyframes cyberShimmer {
    0%, 90% { left: -100%; }
    95%, 100% { left: 100%; }
}

/* محتوى الإجراءات */
.cyber-actions-content {
    display: flex;
    align-items: center;
    justify-content: space-between;
    gap: 0;
    height: 100%;
    position: relative;
    z-index: 1;
}

/* الأقسام */
.cyber-section {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 0 12px;
}

.cyber-section:first-child {
    padding-left: 0;
}

.cyber-section:last-child {
    padding-right: 0;
}

/* قسم المجموع */
.total-section {
    min-width: 200px;
}

.cyber-total-label {
    color: #94a3b8;
    font-size: 12px;
    font-weight: 600;
    margin-right: 8px;
}

.cyber-total-amount {
    display: flex;
    align-items: baseline;
    color: #38bdf8;
    font-size: 20px;
    font-weight: 700;
    text-shadow: 0 0 10px rgba(56, 189, 248, 0.5);
}

.currency-symbol {
    font-size: 14px;
    margin-right: 2px;
    opacity: 0.8;
}

/* الفواصل */
.cyber-divider {
    width: 1px;
    height: 40px;
    background: linear-gradient(to bottom, 
        transparent, 
        rgba(56, 189, 248, 0.3), 
        rgba(56, 189, 248, 0.3),
        transparent);
    margin: 0 8px;
}

/* الأزرار الأساسية */
.cyber-btn {
    position: relative;
    padding: 8px 16px;
    background: rgba(15, 23, 42, 0.8);
    border: 1px solid rgba(56, 189, 248, 0.3);
    border-radius: 8px;
    color: #cbd5e1;
    cursor: pointer;
    transition: all 0.2s ease;
    display: flex;
    align-items: center;
    gap: 6px;
    font-size: 12px;
    font-weight: 600;
    height: 40px;
    overflow: hidden;
    white-space: nowrap;
}

.cyber-btn::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, 
        transparent, 
        rgba(255, 255, 255, 0.1), 
        transparent);
    transition: left 0.5s;
}

.cyber-btn:hover::before {
    left: 100%;
}

.cyber-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
}

.cyber-btn i {
    font-size: 14px;
}

.cyber-btn span {
    font-size: 11px;
}

/* حالة التعطيل */
.cyber-btn:disabled {
    opacity: 0.5;
    cursor: not-allowed;
    transform: none !important;
}

/* ألوان الأزرار */
.cyber-btn-success {
    background: linear-gradient(135deg, #064e3b, #065f46);
    border-color: rgba(16, 185, 129, 0.4);
}

.cyber-btn-success:hover {
    background: linear-gradient(135deg, #10b981, #34d399);
    border-color: #10b981;
    color: white;
    box-shadow: 0 0 20px rgba(16, 185, 129, 0.3);
}

.cyber-btn-info {
    background: linear-gradient(135deg, #1e3a8a, #1e40af);
    border-color: rgba(59, 130, 246, 0.4);
}

.cyber-btn-info:hover {
    background: linear-gradient(135deg, #3b82f6, #60a5fa);
    border-color: #3b82f6;
    color: white;
    box-shadow: 0 0 20px rgba(59, 130, 246, 0.3);
}

.cyber-btn-warning {
    background: linear-gradient(135deg, #78350f, #92400e);
    border-color: rgba(245, 158, 11, 0.4);
}

.cyber-btn-warning:hover {
    background: linear-gradient(135deg, #f59e0b, #fbbf24);
    border-color: #f59e0b;
    color: white;
    box-shadow: 0 0 20px rgba(245, 158, 11, 0.3);
}

.cyber-btn-orange {
    background: linear-gradient(135deg, #7c2d12, #9a3412);
    border-color: rgba(249, 115, 22, 0.4);
}

.cyber-btn-orange:hover {
    background: linear-gradient(135deg, #f97316, #fb923c);
    border-color: #f97316;
    color: white;
    box-shadow: 0 0 20px rgba(249, 115, 22, 0.3);
}

.cyber-btn-danger {
    background: linear-gradient(135deg, #7f1d1d, #991b1b);
    border-color: rgba(239, 68, 68, 0.4);
}

.cyber-btn-danger:hover {
    background: linear-gradient(135deg, #dc2626, #ef4444);
    border-color: #ef4444;
    color: white;
    box-shadow: 0 0 20px rgba(239, 68, 68, 0.3);
}

.cyber-btn-whatsapp {
    background: linear-gradient(135deg, #14532d, #166534);
    border-color: rgba(37, 211, 102, 0.4);
}

.cyber-btn-whatsapp:hover {
    background: linear-gradient(135deg, #25d366, #128c7e);
    border-color: #25d366;
    color: white;
    box-shadow: 0 0 20px rgba(37, 211, 102, 0.3);
}

.cyber-btn-primary {
    background: linear-gradient(135deg, #312e81, #4c1d95);
    border-color: rgba(99, 102, 241, 0.4);
}

.cyber-btn-primary:hover {
    background: linear-gradient(135deg, #6366f1, #818cf8);
    border-color: #6366f1;
    color: white;
    box-shadow: 0 0 20px rgba(99, 102, 241, 0.3);
}

/* تأثير التحميل */
.cyber-loading {
    margin-left: 4px;
}

/* التجاوب */
@media (max-width: 768px) {
    .cyber-pos-actions-container {
        padding: 8px 10px;
        border-radius: 8px 8px 0 0;
    }
    
    .cyber-actions-content {
        flex-wrap: wrap;
        gap: 8px;
    }
    
    .cyber-section {
        padding: 4px 8px;
    }
    
    .cyber-divider {
        display: none;
    }
    
    .total-section {
        width: 100%;
        justify-content: center;
        border-bottom: 1px solid rgba(56, 189, 248, 0.2);
        padding-bottom: 8px;
        margin-bottom: 8px;
    }
    
    .cyber-btn {
        height: 36px;
        padding: 6px 12px;
        font-size: 11px;
    }
    
    .cyber-btn i {
        font-size: 12px;
    }
    
    .cyber-btn span {
        font-size: 10px;
    }
}
</style>

<!-- JavaScript for Sale Order Button -->
<script>
$(document).ready(function() {
    // تحديث عرض الخصم عند التحميل الأولي
    function updateDiscountDisplay() {
        var discount_amount = parseFloat($('#discount_amount').val()) || 0;
        var discount_type = $('#discount_type').val();
        var rp_redeemed_amount = parseFloat($('#rp_redeemed_amount').val()) || 0;
        
        var display_text = '';
        if (discount_amount > 0) {
            if (discount_type == 'percentage') {
                display_text = discount_amount + '%';
            } else {
                display_text = discount_amount;
            }
        }
        
        if (rp_redeemed_amount > 0) {
            if (display_text) display_text += ' + ';
            display_text += rp_redeemed_amount + ' (RP)';
        }
        
        if (!display_text) display_text = '0';
        
        $('#discount_display').val(display_text);
    }
    
    // تحديث العرض عند التحميل
    updateDiscountDisplay();
    
    // تحديث العرض عند تغيير قيم الخصم
    $(document).on('change', '#discount_amount, #discount_type, #rp_redeemed_amount', function() {
        updateDiscountDisplay();
    });
    
    // تحديث العرض عند إغلاق مودال الخصم
    $('#posEditDiscountModal').on('hidden.bs.modal', function() {
        updateDiscountDisplay();
    });
    
    // معالج زر Sale Order المحدث
    $('.pos-express-finalize').click(function() {
        console.log('Sale Order button clicked');
        
        // التحقق من وجود منتجات في الجدول
        if ($('table#pos_table tbody').find('.product_row').length <= 0) {
            toastr.warning(LANG.no_products_added || 'Please add products to create sale order');
            return false;
        }

        // التحقق من نقاط المكافآت إذا كانت مفعلة
        if ($('#reward_point_enabled').length) {
            var validate_rp = isValidatRewardPoint();
            if (!validate_rp['is_valid']) {
                toastr.error(validate_rp['msg']);
                return false;
            }
        }

        // إزالة الصفوف الفارغة قبل الإرسال
        if (typeof removeEmptyRowsBeforeSubmit === 'function') {
            removeEmptyRowsBeforeSubmit();
        }

        // التحقق من صحة النموذج
        var is_valid = true;
        if (typeof isValidPosForm === 'function') {
            is_valid = isValidPosForm();
        }
        
        if (is_valid != true) {
            return false;
        }

        // تحضير البيانات مع حالة sales_order
        var data = pos_form_obj.serialize();
        data = data + '&status=sales_order';
        var url = pos_form_obj.attr('action');

        console.log('Sending sale order data:', data);

        // تعطيل أزرار العمليات
        if (typeof disable_pos_form_actions === 'function') {
            disable_pos_form_actions();
        }
        
        // إرسال البيانات
        $.ajax({
            method: 'POST',
            url: url,
            data: data,
            dataType: 'json',
            success: function(result) {
                console.log('Sale order response:', result);
                
                if (typeof enable_pos_form_actions === 'function') {
                    enable_pos_form_actions();
                }
                
                if (result.success == 1) {
                    if (typeof reset_pos_form === 'function') {
                        reset_pos_form();
                    }
                    toastr.success(result.msg || 'Sale order created successfully');

                    // طباعة الإيصال إذا كان مفعلاً
                    if (result.receipt && result.receipt.is_enabled && typeof pos_print === 'function') {
                        pos_print(result.receipt);
                    }
                } else {
                    toastr.error(result.msg || 'Error creating sale order');
                }
            },
            error: function(xhr, status, error) {
                console.error('Sale Order Error:', xhr.responseText);
                
                if (typeof enable_pos_form_actions === 'function') {
                    enable_pos_form_actions();
                }
                
                var errorMsg = 'Error occurred while processing the sale order';
                try {
                    var response = JSON.parse(xhr.responseText);
                    if (response.message) {
                        errorMsg = response.message;
                    }
                } catch(e) {
                    // استخدام الرسالة الافتراضية
                }
                
                toastr.error(errorMsg);
            }
        });
    });
});
</script>

<?php if(isset($transaction)): ?>
    <?php echo $__env->make('sale_pos.partials.edit_discount_modal', [
        'sales_discount' => $transaction->discount_amount,
        'discount_type' => $transaction->discount_type,
        'rp_redeemed' => $transaction->rp_redeemed,
        'rp_redeemed_amount' => $transaction->rp_redeemed_amount,
        'max_available' => !empty($redeem_details['points']) ? $redeem_details['points'] : 0,
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php else: ?>
    <?php echo $__env->make('sale_pos.partials.edit_discount_modal', [
        'sales_discount' => $business_details->default_sales_discount,
        'discount_type' => 'percentage',
        'rp_redeemed' => 0,
        'rp_redeemed_amount' => 0,
        'max_available' => 0,
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>

<?php if(isset($transaction)): ?>
    <?php echo $__env->make('sale_pos.partials.edit_order_tax_modal', ['selected_tax' => $transaction->tax_id], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php else: ?>
    <?php echo $__env->make('sale_pos.partials.edit_order_tax_modal', [
        'selected_tax' => $business_details->default_sales_tax,
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>

<?php echo $__env->make('sale_pos.partials.edit_shipping_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/sale_pos/partials/pos_form_actions.blade.php ENDPATH**/ ?>