<?php $__env->startSection('title', 'SAP Synchronization'); ?>

<?php $__env->startSection('content'); ?>
<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>SAP Synchronization
        <small>Manage SAP B1 Integration</small>
    </h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Transactions</h3>
                    <div class="box-tools">
                        <button type="button" class="btn btn-primary btn-sm" id="sync-pending">
                            <i class="fa fa-refresh"></i> Sync Pending Transactions
                        </button>
                    </div>
                </div>
                <div class="box-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="sap_transactions_table">
                            <thead>
                                <tr>
                                    <th>Invoice/Quotation #</th>
                                    <th>Date</th>
                                    <th>Customer</th>
                                    <th>Location</th>
                                    <th>Total</th>
                                    <th>Type</th>
                                    <th>SAP Document #</th>
                                    <th>SAP Status</th>
                                    <th>Last Sync</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize the datatable
        var transactions_table = $('#sap_transactions_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "<?php echo e(action([\App\Http\Controllers\SapTSyncController::class, 'getTransactions']), false); ?>",
                data: function(d) {
                    // Add any filter parameters here
                }
            },
            columns: [
                { data: 'invoice_no', name: 'invoice_no' },
                { data: 'transaction_date', name: 'transaction_date' },
                { data: 'customer', name: 'contact.name' },
                { data: 'location', name: 'business_location.name' },
                { data: 'final_total', name: 'final_total' },
                { data: 'status', name: 'status' },
                { data: 'sap_document_id', name: 'sap_document_id' },
                { data: 'sap_sync_status', name: 'sap_sync_status' },
                { data: 'sap_sync_date', name: 'sap_sync_date' },
                { data: 'action', name: 'action', searchable: false, orderable: false },
            ],
            order: [[1, 'desc']]
        });
        
        // Sync a single transaction
        $(document).on('click', '.sync-to-sap', function() {
            var transaction_id = $(this).data('id');
            var button = $(this);
            
            button.prop('disabled', true);
            button.html('<i class="fa fa-spinner fa-spin"></i>');
            
            $.ajax({
                url: "<?php echo e(action([\App\Http\Controllers\SapTSyncController::class, 'syncTransaction']), false); ?>",
                method: 'POST',
                data: {
                    transaction_id: transaction_id,
                    _token: "<?php echo e(csrf_token(), false); ?>"
                },
                success: function(response) {
                    if (response.success) {
                        toastr.success(response.message);
                    } else {
                        toastr.error(response.message);
                    }
                    transactions_table.ajax.reload();
                },
                error: function(xhr) {
                    toastr.error('An error occurred: ' + xhr.responseText);
                    button.prop('disabled', false);
                    button.html('Sync to SAP');
                }
            });
        });
        
        // Sync all pending transactions
        $('#sync-pending').click(function() {
            var button = $(this);
            
            button.prop('disabled', true);
            button.html('<i class="fa fa-spinner fa-spin"></i> Processing...');
            
            $.ajax({
                url: "<?php echo e(action([\App\Http\Controllers\SapTSyncController::class, 'syncMultiple']), false); ?>",
                method: 'POST',
                data: {
                    _token: "<?php echo e(csrf_token(), false); ?>"
                },
                success: function(response) {
                    if (response.success) {
                        toastr.success(response.message);
                    } else {
                        toastr.error(response.message);
                    }
                    transactions_table.ajax.reload();
                    button.prop('disabled', false);
                    button.html('<i class="fa fa-refresh"></i> Sync Pending Transactions');
                },
                error: function(xhr) {
                    toastr.error('An error occurred: ' + xhr.responseText);
                    button.prop('disabled', false);
                    button.html('<i class="fa fa-refresh"></i> Sync Pending Transactions');
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nhiq/combossas/resources/views/sap/index.blade.php ENDPATH**/ ?>