<!-- قالب فاتورة باللغة العربية - تصميم من اليمين إلى اليسار -->
<div dir="rtl" style="color: #000000 !important; font-family: Arial, sans-serif;">
    <!-- الترويسة مع الشعارات -->
    <div class="row" style="margin-bottom: 20px;">
        <div class="col-xs-4" style="float: right; width: 33%;">
            <!-- الباركود والفرع -->
            <div style="text-align: center;">
                <div style="background-color: #f9a825; color: #000; padding: 5px 10px; font-weight: bold; display: inline-block; margin-bottom: 10px;">
                    فرع <?php echo e($receipt_details->location_name ?? 'الصرافية', false); ?>

                </div>
                <?php if(!empty($receipt_details->barcode)): ?>
                    <div style="margin-top: 10px;">
                        <img src="<?php echo e($receipt_details->barcode, false); ?>" alt="Barcode" style="max-width: 100%;">
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="col-xs-4" style="float: right; width: 33%; text-align: center;">
            <!-- شعار وعنوان -->
            <div style="text-align: center;">
                <div style="background-color: #f9a825; color: #000; padding: 5px 10px; font-weight: bold; display: inline-block; margin-bottom: 10px;">
                    <?php echo e($receipt_details->invoice_heading ?? 'أمر مبيع', false); ?>

                </div>
                <?php if(!empty($receipt_details->logo)): ?>
                    <div style="margin-top: 10px;">
                        <img src="<?php echo e($receipt_details->logo, false); ?>" alt="Logo" style="max-width: 100px;">
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="col-xs-4" style="float: left; width: 33%; text-align: center;">
            <!-- شعار الشركة الثانوي إن وجد -->
            <?php if(!empty($receipt_details->secondary_logo)): ?>
                <div style="text-align: center;">
                    <img src="<?php echo e($receipt_details->secondary_logo, false); ?>" alt="Secondary Logo" style="max-width: 150px;">
                </div>
            <?php endif; ?>
        </div>
    </div>

    <div style="clear: both;"></div>

    <!-- معلومات الفاتورة -->
    <div class="row" style="margin-bottom: 20px;">
        <div class="col-xs-6" style="float: right; width: 50%;">
            <table style="width: 100%; border-collapse: collapse; border: 1px solid #ddd;">
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd; width: 40%;"><?php echo e($receipt_details->invoice_no_prefix ?? 'رقم الفاتورة', false); ?></td>
                    <td style="padding: 8px; border: 1px solid #ddd; width: 60%;"><?php echo e($receipt_details->invoice_no, false); ?></td>
                </tr>
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;"><?php echo e($receipt_details->date_label ?? 'التاريخ', false); ?></td>
                    <td style="padding: 8px; border: 1px solid #ddd;"><?php echo e($receipt_details->invoice_date, false); ?></td>
                </tr>
                <?php if(!empty($receipt_details->due_date_label)): ?>
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;"><?php echo e($receipt_details->due_date_label, false); ?></td>
                    <td style="padding: 8px; border: 1px solid #ddd;"><?php echo e($receipt_details->due_date, false); ?></td>
                </tr>
                <?php endif; ?>
                
                <?php if(!empty($receipt_details->sales_person_label)): ?>
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;"><?php echo e($receipt_details->sales_person_label, false); ?></td>
                    <td style="padding: 8px; border: 1px solid #ddd;"><?php echo e($receipt_details->sales_person, false); ?></td>
                </tr>
                <?php endif; ?>
            </table>
            
            <table style="width: 100%; border-collapse: collapse; border: 1px solid #ddd; margin-top: 10px;">
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd; width: 40%;"><?php echo e($receipt_details->client_id_label ?? 'رمز العميل', false); ?></td>
                    <td style="padding: 8px; border: 1px solid #ddd; width: 60%;"><?php echo e($receipt_details->client_id, false); ?></td>
                </tr>
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;"><?php echo e($receipt_details->invoice_type_label ?? 'نوع الفاتورة', false); ?></td>
                    <td style="padding: 8px; border: 1px solid #ddd;"><?php echo e($receipt_details->invoice_type ?? 'آجل', false); ?></td>
                </tr>
                
                <?php if(!empty($receipt_details->commission_agent_label)): ?>
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;"><?php echo e($receipt_details->commission_agent_label, false); ?></td>
                    <td style="padding: 8px; border: 1px solid #ddd;"><?php echo e($receipt_details->commission_agent, false); ?></td>
                </tr>
                <?php endif; ?>
                
                <?php if(!empty($receipt_details->customer_rp_label)): ?>
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;"><?php echo e($receipt_details->customer_rp_label, false); ?></td>
                    <td style="padding: 8px; border: 1px solid #ddd;"><?php echo e($receipt_details->customer_total_rp, false); ?></td>
                </tr>
                <?php endif; ?>
            </table>
            
            <!-- معلومات الإصلاح إذا وجدت -->
            <?php if(!empty($receipt_details->repair_brand) || !empty($receipt_details->repair_device) || !empty($receipt_details->repair_model_no) || !empty($receipt_details->repair_serial_no) || !empty($receipt_details->repair_status) || !empty($receipt_details->repair_warranty)): ?>
            <table style="width: 100%; border-collapse: collapse; border: 1px solid #ddd; margin-top: 10px;">
                <?php if(!empty($receipt_details->brand_label) || !empty($receipt_details->repair_brand)): ?>
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd; width: 40%;"><?php echo e($receipt_details->brand_label ?? 'العلامة التجارية', false); ?></td>
                    <td style="padding: 8px; border: 1px solid #ddd; width: 60%;"><?php echo e($receipt_details->repair_brand, false); ?></td>
                </tr>
                <?php endif; ?>
                
                <?php if(!empty($receipt_details->device_label) || !empty($receipt_details->repair_device)): ?>
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;"><?php echo e($receipt_details->device_label ?? 'الجهاز', false); ?></td>
                    <td style="padding: 8px; border: 1px solid #ddd;"><?php echo e($receipt_details->repair_device, false); ?></td>
                </tr>
                <?php endif; ?>
                
                <?php if(!empty($receipt_details->model_no_label) || !empty($receipt_details->repair_model_no)): ?>
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;"><?php echo e($receipt_details->model_no_label ?? 'رقم الموديل', false); ?></td>
                    <td style="padding: 8px; border: 1px solid #ddd;"><?php echo e($receipt_details->repair_model_no, false); ?></td>
                </tr>
                <?php endif; ?>
                
                <?php if(!empty($receipt_details->serial_no_label) || !empty($receipt_details->repair_serial_no)): ?>
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;"><?php echo e($receipt_details->serial_no_label ?? 'الرقم التسلسلي', false); ?></td>
                    <td style="padding: 8px; border: 1px solid #ddd;"><?php echo e($receipt_details->repair_serial_no, false); ?></td>
                </tr>
                <?php endif; ?>
                
                <?php if(!empty($receipt_details->repair_status_label) || !empty($receipt_details->repair_status)): ?>
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;"><?php echo e($receipt_details->repair_status_label ?? 'حالة الإصلاح', false); ?></td>
                    <td style="padding: 8px; border: 1px solid #ddd;"><?php echo e($receipt_details->repair_status, false); ?></td>
                </tr>
                <?php endif; ?>
                
                <?php if(!empty($receipt_details->repair_warranty_label) || !empty($receipt_details->repair_warranty)): ?>
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;"><?php echo e($receipt_details->repair_warranty_label ?? 'الضمان', false); ?></td>
                    <td style="padding: 8px; border: 1px solid #ddd;"><?php echo e($receipt_details->repair_warranty, false); ?></td>
                </tr>
                <?php endif; ?>
            </table>
            <?php endif; ?>
        </div>

        <div class="col-xs-6" style="float: left; width: 50%;">
            <table style="width: 95%; margin-left: 0; margin-right: auto; border-collapse: collapse; border: 1px solid #ddd;">
                <tr>
                    <td style="background-color: #f9a825; padding: 8px; font-weight: bold; border: 1px solid #ddd;"><?php echo e($receipt_details->customer_label ?? 'فاتورة إلى', false); ?></td>
                </tr>
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <?php if(!empty($receipt_details->customer_name)): ?>
                            <?php echo e($receipt_details->customer_name, false); ?>

                        <?php else: ?>
                            <?php echo e($receipt_details->customer_info ?? 'نقدي صرافية بالمحل', false); ?>

                        <?php endif; ?>
                    </td>
                </tr>
                <?php if(!empty($receipt_details->address)): ?>
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;"><?php echo $receipt_details->address; ?></td>
                </tr>
                <?php endif; ?>
                <?php if(!empty($receipt_details->contact)): ?>
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd; direction: ltr; text-align: right;"><?php echo e($receipt_details->contact, false); ?></td>
                </tr>
                <?php endif; ?>
                <?php if(!empty($receipt_details->customer_tax_label)): ?>
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;"><?php echo e($receipt_details->customer_tax_label, false); ?>: <?php echo e($receipt_details->customer_tax_number, false); ?></td>
                </tr>
                <?php endif; ?>
                
                <!-- معلومات الطاولة والنادل -->
                <?php if(!empty($receipt_details->table_label) || !empty($receipt_details->table)): ?>
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <?php if(!empty($receipt_details->table_label)): ?>
                            <b><?php echo e($receipt_details->table_label, false); ?></b>
                        <?php endif; ?>
                        <?php echo e($receipt_details->table, false); ?>

                    </td>
                </tr>
                <?php endif; ?>
                
                <?php if(!empty($receipt_details->service_staff_label) || !empty($receipt_details->service_staff)): ?>
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <?php if(!empty($receipt_details->service_staff_label)): ?>
                            <b><?php echo e($receipt_details->service_staff_label, false); ?></b>
                        <?php endif; ?>
                        <?php echo e($receipt_details->service_staff, false); ?>

                    </td>
                </tr>
                <?php endif; ?>
                
                <!-- معلومات الشحن المخصصة -->
                <?php if(!empty($receipt_details->shipping_custom_field_1_label)): ?>
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong><?php echo e($receipt_details->shipping_custom_field_1_label, false); ?>:</strong> 
                        <?php echo e($receipt_details->shipping_custom_field_1_value ?? '', false); ?>

                    </td>
                </tr>
                <?php endif; ?>
                
                <?php if(!empty($receipt_details->shipping_custom_field_2_label)): ?>
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong><?php echo e($receipt_details->shipping_custom_field_2_label, false); ?>:</strong> 
                        <?php echo e($receipt_details->shipping_custom_field_2_value ?? '', false); ?>

                    </td>
                </tr>
                <?php endif; ?>
                
                <?php if(!empty($receipt_details->shipping_custom_field_3_label)): ?>
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong><?php echo e($receipt_details->shipping_custom_field_3_label, false); ?>:</strong> 
                        <?php echo e($receipt_details->shipping_custom_field_3_value ?? '', false); ?>

                    </td>
                </tr>
                <?php endif; ?>
                
                <?php if(!empty($receipt_details->shipping_custom_field_4_label)): ?>
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong><?php echo e($receipt_details->shipping_custom_field_4_label, false); ?>:</strong> 
                        <?php echo e($receipt_details->shipping_custom_field_4_value ?? '', false); ?>

                    </td>
                </tr>
                <?php endif; ?>
                
                <?php if(!empty($receipt_details->shipping_custom_field_5_label)): ?>
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong><?php echo e($receipt_details->shipping_custom_field_5_label, false); ?>:</strong> 
                        <?php echo e($receipt_details->shipping_custom_field_5_value ?? '', false); ?>

                    </td>
                </tr>
                <?php endif; ?>
                
                <!-- أرقام طلبات البيع -->
                <?php if(!empty($receipt_details->sale_orders_invoice_no)): ?>
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong><?php echo app('translator')->get('restaurant.order_no'); ?>:</strong> 
                        <?php echo e($receipt_details->sale_orders_invoice_no ?? '', false); ?>

                    </td>
                </tr>
                <?php endif; ?>
                
                <?php if(!empty($receipt_details->sale_orders_invoice_date)): ?>
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong><?php echo app('translator')->get('lang_v1.order_dates'); ?>:</strong> 
                        <?php echo e($receipt_details->sale_orders_invoice_date ?? '', false); ?>

                    </td>
                </tr>
                <?php endif; ?>
                
                <!-- حقول مخصصة للبيع -->
                <?php if(!empty($receipt_details->sell_custom_field_1_value)): ?>
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong><?php echo e($receipt_details->sell_custom_field_1_label, false); ?>:</strong> 
                        <?php echo e($receipt_details->sell_custom_field_1_value ?? '', false); ?>

                    </td>
                </tr>
                <?php endif; ?>
                
                <?php if(!empty($receipt_details->sell_custom_field_2_value)): ?>
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong><?php echo e($receipt_details->sell_custom_field_2_label, false); ?>:</strong> 
                        <?php echo e($receipt_details->sell_custom_field_2_value ?? '', false); ?>

                    </td>
                </tr>
                <?php endif; ?>
                
                <?php if(!empty($receipt_details->sell_custom_field_3_value)): ?>
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong><?php echo e($receipt_details->sell_custom_field_3_label, false); ?>:</strong> 
                        <?php echo e($receipt_details->sell_custom_field_3_value ?? '', false); ?>

                    </td>
                </tr>
                <?php endif; ?>
                
                <?php if(!empty($receipt_details->sell_custom_field_4_value)): ?>
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong><?php echo e($receipt_details->sell_custom_field_4_label, false); ?>:</strong> 
                        <?php echo e($receipt_details->sell_custom_field_4_value ?? '', false); ?>

                    </td>
                </tr>
                <?php endif; ?>
            </table>
            
            <?php if(!empty($receipt_details->types_of_service)): ?>
            <table style="width: 95%; margin-left: 0; margin-right: auto; border-collapse: collapse; border: 1px solid #ddd; margin-top: 10px;">
                <tr>
                    <td style="padding: 8px; border: 1px solid #ddd;">
                        <strong><?php echo e($receipt_details->types_of_service_label, false); ?>:</strong> 
                        <?php echo e($receipt_details->types_of_service, false); ?>

                        <!-- معلومات نوع الخدمة المخصصة -->
                        <?php if(!empty($receipt_details->types_of_service_custom_fields)): ?>
                            <?php $__currentLoopData = $receipt_details->types_of_service_custom_fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <br><strong><?php echo e($key, false); ?>:</strong> <?php echo e($value, false); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </td>
                </tr>
            </table>
            <?php endif; ?>
        </div>
    </div>

    <div style="clear: both;"></div>

    <!-- جزء إصلاح مشترك إذا كان موجوداً -->
    <?php if ($__env->exists('sale_pos.receipts.partial.common_repair_invoice')) echo $__env->make('sale_pos.receipts.partial.common_repair_invoice', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- جدول المنتجات -->
    <div class="row">
        <div class="col-xs-12">
            <table style="width: 100%; border-collapse: collapse; border: 1px solid #ddd;">
                <thead>
                    <tr>
                        <th style="padding: 8px; text-align: center; border: 1px solid #ddd; background-color: #f0f0f0;">ت</th>
                        <th style="padding: 8px; text-align: center; border: 1px solid #ddd; background-color: #f0f0f0;">تسلسل</th>
                        <th style="padding: 8px; text-align: right; border: 1px solid #ddd; background-color: #f0f0f0;"><?php echo e($receipt_details->table_product_label ?? 'الوصف', false); ?></th>
                        <th style="padding: 8px; text-align: center; border: 1px solid #ddd; background-color: #f0f0f0;"><?php echo e($receipt_details->table_qty_label ?? 'الكمية', false); ?></th>
                        <th style="padding: 8px; text-align: center; border: 1px solid #ddd; background-color: #f0f0f0;"><?php echo e($receipt_details->table_unit_label ?? 'الوحدة', false); ?></th>
                        <th style="padding: 8px; text-align: center; border: 1px solid #ddd; background-color: #f0f0f0;"><?php echo e($receipt_details->table_unit_price_label ?? 'السعر', false); ?></th>
                        <?php if(!empty($receipt_details->discounted_unit_price_label)): ?>
                            <th style="padding: 8px; text-align: center; border: 1px solid #ddd; background-color: #f0f0f0;"><?php echo e($receipt_details->discounted_unit_price_label, false); ?></th>
                        <?php endif; ?>
                        <?php if(!empty($receipt_details->item_discount_label)): ?>
                            <th style="padding: 8px; text-align: center; border: 1px solid #ddd; background-color: #f0f0f0;"><?php echo e($receipt_details->item_discount_label, false); ?></th>
                        <?php endif; ?>
                        <th style="padding: 8px; text-align: center; border: 1px solid #ddd; background-color: #f0f0f0;"><?php echo e($receipt_details->table_subtotal_label ?? 'السعر الإجمالي', false); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $receipt_details->lines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $line): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr style="<?php echo e($index % 2 == 0 ? 'background-color: #f9f9f9;' : 'background-color: #e6e6e6;', false); ?>">
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;"><?php echo e(isset($line['custom_field_1']) ? $line['custom_field_1'] : ($index + 1), false); ?></td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;"><?php echo e(str_pad($index + 1, 3, '0', STR_PAD_LEFT), false); ?></td>
                            <td style="padding: 8px; text-align: right; border: 1px solid #ddd;">
                                <?php if(!empty($line['image'])): ?>
                                    <img src="<?php echo e($line['image'], false); ?>" alt="صورة المنتج" width="50" style="float: right; margin-left: 8px;">
                                <?php endif; ?>
                                <?php echo e($line['name'], false); ?> <?php echo e($line['product_variation'], false); ?> <?php echo e($line['variation'], false); ?>

                                <?php if(!empty($line['sub_sku'])): ?>, <?php echo e($line['sub_sku'], false); ?> <?php endif; ?> 
                                <?php if(!empty($line['brand'])): ?>, <?php echo e($line['brand'], false); ?> <?php endif; ?> 
                                <?php if(!empty($line['cat_code'])): ?>, <?php echo e($line['cat_code'], false); ?><?php endif; ?>
                                <?php if(!empty($line['product_custom_fields'])): ?>, <?php echo e($line['product_custom_fields'], false); ?> <?php endif; ?>
                                
                                <?php if(!empty($line['product_description'])): ?>
                                    <br><small><?php echo $line['product_description']; ?></small>
                                <?php endif; ?>
                                
                                <?php if(!empty($line['sell_line_note'])): ?>
                                    <br><small><?php echo $line['sell_line_note']; ?></small>
                                <?php endif; ?>
                                
                                <?php if(!empty($line['lot_number'])): ?>
                                    <br> <?php echo e($line['lot_number_label'], false); ?>: <?php echo e($line['lot_number'], false); ?>

                                <?php endif; ?>
                                
                                <?php if(!empty($line['product_expiry'])): ?>
                                    , <?php echo e($line['product_expiry_label'], false); ?>: <?php echo e($line['product_expiry'], false); ?>

                                <?php endif; ?>
                                
                                <?php if(!empty($line['warranty_name'])): ?>
                                    <br><small><?php echo e($line['warranty_name'], false); ?></small>
                                <?php endif; ?> 
                                
                                <?php if(!empty($line['warranty_exp_date'])): ?>
                                    <small>- <?php echo e(\Carbon::createFromTimestamp(strtotime($line['warranty_exp_date']))->format(session('business.date_format')), false); ?></small>
                                <?php endif; ?>
                                
                                <?php if(!empty($line['warranty_description'])): ?>
                                    <small> <?php echo e($line['warranty_description'] ?? '', false); ?></small>
                                <?php endif; ?>
                                
                                <?php if($receipt_details->show_base_unit_details && $line['quantity'] && $line['base_unit_multiplier'] !== 1): ?>
                                    <br><small>
                                        1 <?php echo e($line['units'], false); ?> = <?php echo e($line['base_unit_multiplier'], false); ?> <?php echo e($line['base_unit_name'], false); ?> <br>
                                        <?php echo e($line['base_unit_price'], false); ?> x <?php echo e($line['orig_quantity'], false); ?> = <?php echo e($line['line_total'], false); ?>

                                    </small>
                                <?php endif; ?>
                            </td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">
                                <?php echo e($line['quantity'], false); ?> <?php echo e($line['units'], false); ?>

                                
                                <?php if($receipt_details->show_base_unit_details && $line['quantity'] && $line['base_unit_multiplier'] !== 1): ?>
                                    <br><small>
                                        <?php echo e($line['quantity'], false); ?> x <?php echo e($line['base_unit_multiplier'], false); ?> = <?php echo e($line['orig_quantity'], false); ?> <?php echo e($line['base_unit_name'], false); ?>

                                    </small>
                                <?php endif; ?>
                            </td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;"><?php echo e($line['units'] ?? 'غم 100', false); ?></td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;"><?php echo e($line['unit_price_before_discount'], false); ?> د.ع</td>
                            
                            <?php if(!empty($receipt_details->discounted_unit_price_label)): ?>
                                <td style="padding: 8px; text-align: center; border: 1px solid #ddd;"><?php echo e($line['unit_price_inc_tax'], false); ?> د.ع</td>
                            <?php endif; ?>
                            
                            <?php if(!empty($receipt_details->item_discount_label)): ?>
                                <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">
                                    <?php echo e($line['total_line_discount'] ?? '0.00', false); ?>

                                    <?php if(!empty($line['line_discount_percent'])): ?>
                                        (<?php echo e($line['line_discount_percent'], false); ?>%)
                                    <?php endif; ?>
                                </td>
                            <?php endif; ?>
                            
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;"><?php echo e($line['line_total'], false); ?> د.ع</td>
                        </tr>
                        
                        <?php if(!empty($line['modifiers'])): ?>
                            <?php $__currentLoopData = $line['modifiers']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $modifier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr style="background-color: #f9f9f9;">
                                    <td style="padding: 8px; text-align: center; border: 1px solid #ddd;"></td>
                                    <td style="padding: 8px; text-align: center; border: 1px solid #ddd;"></td>
                                    <td style="padding: 8px; text-align: right; border: 1px solid #ddd;">
                                        <?php echo e($modifier['name'], false); ?> <?php echo e($modifier['variation'], false); ?>

                                        <?php if(!empty($modifier['sub_sku'])): ?>, <?php echo e($modifier['sub_sku'], false); ?> <?php endif; ?> 
                                        <?php if(!empty($modifier['cat_code'])): ?>, <?php echo e($modifier['cat_code'], false); ?><?php endif; ?>
                                        <?php if(!empty($modifier['sell_line_note'])): ?>
                                            (<?php echo e($modifier['sell_line_note'], false); ?>)
                                        <?php endif; ?>
                                    </td>
                                    <td style="padding: 8px; text-align: center; border: 1px solid #ddd;"><?php echo e($modifier['quantity'], false); ?> <?php echo e($modifier['units'], false); ?></td>
                                    <td style="padding: 8px; text-align: center; border: 1px solid #ddd;"><?php echo e($modifier['units'], false); ?></td>
                                    <td style="padding: 8px; text-align: center; border: 1px solid #ddd;"><?php echo e($modifier['unit_price_inc_tax'], false); ?> د.ع</td>
                                    
                                    <?php if(!empty($receipt_details->discounted_unit_price_label)): ?>
                                        <td style="padding: 8px; text-align: center; border: 1px solid #ddd;"><?php echo e($modifier['unit_price_exc_tax'], false); ?> د.ع</td>
                                    <?php endif; ?>
                                    
                                    <?php if(!empty($receipt_details->item_discount_label)): ?>
                                        <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">0.00</td>
                                    <?php endif; ?>
                                    
                                    <td style="padding: 8px; text-align: center; border: 1px solid #ddd;"><?php echo e($modifier['line_total'], false); ?> د.ع</td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <!-- قائمة افتراضية إذا لم تكن هناك منتجات -->
                        <tr style="background-color: #f9f9f9;">
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">4</td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">001</td>
                            <td style="padding: 8px; text-align: right; border: 1px solid #ddd;">W بربري - ADF</td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">1.00</td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">غم 100</td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">10,010 د.ع</td>
                            <?php if(!empty($receipt_details->discounted_unit_price_label)): ?>
                                <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">10,010 د.ع</td>
                            <?php endif; ?>
                            <?php if(!empty($receipt_details->item_discount_label)): ?>
                                <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">0.00</td>
                            <?php endif; ?>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">10,010 د.ع</td>
                        </tr>
                        <tr style="background-color: #e6e6e6;">
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">5</td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">002</td>
                            <td style="padding: 8px; text-align: right; border: 1px solid #ddd;">لافي بيلي/لانكوم - ADF</td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">1.00</td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">غم 100</td>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">11,440 د.ع</td>
                            <?php if(!empty($receipt_details->discounted_unit_price_label)): ?>
                                <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">11,440 د.ع</td>
                            <?php endif; ?>
                            <?php if(!empty($receipt_details->item_discount_label)): ?>
                                <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">0.00</td>
                            <?php endif; ?>
                            <td style="padding: 8px; text-align: center; border: 1px solid #ddd;">11,440 د.ع</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- معلومات المدفوعات والإجماليات -->
    <div class="row" style="margin-top: 20px;">
        <div class="col-xs-6" style="float: right; width: 45%;">
            <!-- معلومات المدفوعات -->
            <table style="width: 100%; border-collapse: collapse; margin-bottom: 15px;">
                <?php if(!empty($receipt_details->payments)): ?>
                    <?php $__currentLoopData = $receipt_details->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td style="padding: 5px;"><?php echo e($payment['method'], false); ?></td>
                            <td style="padding: 5px; text-align: left;"><?php echo e($payment['amount'], false); ?></td>
                            <td style="padding: 5px; text-align: left;"><?php echo e($payment['date'], false); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                
                <!-- إجمالي المدفوع -->
                <?php if(!empty($receipt_details->total_paid)): ?>
                    <tr>
                        <th style="padding: 8px; text-align: right; font-weight: bold;">
                            <?php echo $receipt_details->total_paid_label; ?>

                        </th>
                        <td style="padding: 8px; text-align: left;">
                            <?php echo e($receipt_details->total_paid, false); ?>

                        </td>
                    </tr>
                <?php endif; ?>
                
                <!-- المستحق -->
                <?php if(!empty($receipt_details->total_due) && !empty($receipt_details->total_due_label)): ?>
                    <tr>
                        <th style="padding: 8px; text-align: right; font-weight: bold;">
                            <?php echo $receipt_details->total_due_label; ?>

                        </th>
                        <td style="padding: 8px; text-align: left;">
                            <?php echo e($receipt_details->total_due, false); ?>

                        </td>
                    </tr>
                <?php endif; ?>
                
                <?php if(!empty($receipt_details->all_due)): ?>
                    <tr>
                        <th style="padding: 8px; text-align: right; font-weight: bold;">
                            <?php echo $receipt_details->all_bal_label; ?>

                        </th>
                        <td style="padding: 8px; text-align: left;">
                            <?php echo e($receipt_details->all_due, false); ?>

                        </td>
                    </tr>
                <?php endif; ?>
            </table>
            
            <!-- ملخص الحساب -->
            <table style="width: 100%; border-collapse: collapse;">
                <tr>
                    <td style="padding: 8px; text-align: center; border: 1px solid #ddd; background-color: #f9a825; font-weight: bold;"><?php echo e($receipt_details->subtotal_label ?? 'المجموع', false); ?></td>
                    <td style="padding: 8px; text-align: left; border: 1px solid #ddd;"><?php echo e($receipt_details->subtotal ?? '191,620 د.ع', false); ?></td>
                </tr>
                <tr>
                    <td style="padding: 8px; text-align: center; border: 1px solid #ddd; background-color: #f9a825; font-weight: bold;"><?php echo e($receipt_details->previous_balance_label ?? 'الرصيد السابق', false); ?></td>
                    <td style="padding: 8px; text-align: left; border: 1px solid #ddd;"><?php echo e($receipt_details->previous_balance ?? '-15.93', false); ?></td>
                </tr>
                <tr>
                    <td style="padding: 8px; text-align: center; border: 1px solid #ddd; background-color: #f9a825; font-weight: bold;"><?php echo e($receipt_details->total_due_label ?? 'إجمالي الحساب', false); ?></td>
                    <td style="padding: 8px; text-align: left; border: 1px solid #ddd;"><?php echo e($receipt_details->total_due ?? '118.07', false); ?></td>
                </tr>
            </table>
        </div>
        
        <div class="col-xs-6" style="float: left; width: 55%;">
            <!-- تفاصيل الإجمالي -->
            <table style="width: 100%; border-collapse: collapse; margin-bottom: 15px;">
                <?php if(!empty($receipt_details->total_quantity_label)): ?>
                    <tr>
                        <th style="padding: 5px; text-align: right; width: 70%;">
                            <?php echo $receipt_details->total_quantity_label; ?>

                        </th>
                        <td style="padding: 5px; text-align: left;">
                            <?php echo e($receipt_details->total_quantity, false); ?>

                        </td>
                    </tr>
                <?php endif; ?>
                
                <?php if(!empty($receipt_details->total_items_label)): ?>
                    <tr>
                        <th style="padding: 5px; text-align: right; width: 70%;">
                            <?php echo $receipt_details->total_items_label; ?>

                        </th>
                        <td style="padding: 5px; text-align: left;">
                            <?php echo e($receipt_details->total_items, false); ?>

                        </td>
                    </tr>
                <?php endif; ?>
                
                <?php if(!empty($receipt_details->total_exempt_uf)): ?>
                    <tr>
                        <th style="padding: 5px; text-align: right; width: 70%;">
                            <?php echo app('translator')->get('lang_v1.exempt'); ?>
                        </th>
                        <td style="padding: 5px; text-align: left;">
                            <?php echo e($receipt_details->total_exempt, false); ?>

                        </td>
                    </tr>
                <?php endif; ?>
                
                <!-- رسوم الشحن -->
                <?php if(!empty($receipt_details->shipping_charges)): ?>
                    <tr>
                        <th style="padding: 5px; text-align: right; width: 70%;">
                            <?php echo $receipt_details->shipping_charges_label; ?>

                        </th>
                        <td style="padding: 5px; text-align: left;">
                            <?php echo e($receipt_details->shipping_charges, false); ?>

                        </td>
                    </tr>
                <?php endif; ?>
                
                <?php if(!empty($receipt_details->packing_charge)): ?>
                    <tr>
                        <th style="padding: 5px; text-align: right; width: 70%;">
                            <?php echo $receipt_details->packing_charge_label; ?>

                        </th>
                        <td style="padding: 5px; text-align: left;">
                            <?php echo e($receipt_details->packing_charge, false); ?>

                        </td>
                    </tr>
                <?php endif; ?>
                
                <!-- الخصم -->
                <?php if(!empty($receipt_details->discount)): ?>
                    <tr>
                        <th style="padding: 5px; text-align: right; width: 70%;">
                            <?php echo $receipt_details->discount_label; ?>

                        </th>
                        <td style="padding: 5px; text-align: left;">
                            (-) <?php echo e($receipt_details->discount, false); ?>

                        </td>
                    </tr>
                <?php endif; ?>
                
                <?php if(!empty($receipt_details->total_line_discount)): ?>
                    <tr>
                        <th style="padding: 5px; text-align: right; width: 70%;">
                            <?php echo $receipt_details->line_discount_label; ?>

                        </th>
                        <td style="padding: 5px; text-align: left;">
                            (-) <?php echo e($receipt_details->total_line_discount, false); ?>

                        </td>
                    </tr>
                <?php endif; ?>
                
                <?php if(!empty($receipt_details->additional_expenses)): ?>
                    <?php $__currentLoopData = $receipt_details->additional_expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td style="padding: 5px; text-align: right; width: 70%;">
                                <?php echo e($key, false); ?>:
                            </td>
                            <td style="padding: 5px; text-align: left;">
                                (+) <?php echo e($val, false); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                
                <?php if(!empty($receipt_details->reward_point_label)): ?>
                    <tr>
                        <th style="padding: 5px; text-align: right; width: 70%;">
                            <?php echo $receipt_details->reward_point_label; ?>

                        </th>
                        <td style="padding: 5px; text-align: left;">
                            (-) <?php echo e($receipt_details->reward_point_amount, false); ?>

                        </td>
                    </tr>
                <?php endif; ?>
                
                <!-- الضريبة -->
                <?php if(!empty($receipt_details->tax)): ?>
                    <tr>
                        <th style="padding: 5px; text-align: right; width: 70%;">
                            <?php echo $receipt_details->tax_label; ?>

                        </th>
                        <td style="padding: 5px; text-align: left;">
                            (+) <?php echo e($receipt_details->tax, false); ?>

                        </td>
                    </tr>
                <?php endif; ?>
                
                <?php if($receipt_details->round_off_amount > 0): ?>
                    <tr>
                        <th style="padding: 5px; text-align: right; width: 70%;">
                            <?php echo $receipt_details->round_off_label; ?>

                        </th>
                        <td style="padding: 5px; text-align: left;">
                            <?php echo e($receipt_details->round_off, false); ?>

                        </td>
                    </tr>
                <?php endif; ?>
                
                <!-- الإجمالي -->
                <tr>
                    <th style="padding: 5px; text-align: right; width: 70%;">
                        <?php echo $receipt_details->total_label; ?>

                    </th>
                    <td style="padding: 5px; text-align: left;">
                        <?php echo e($receipt_details->total, false); ?>

                        <?php if(!empty($receipt_details->total_in_words)): ?>
                            <br>
                            <small>(<?php echo e($receipt_details->total_in_words, false); ?>)</small>
                        <?php endif; ?>
                    </td>
                </tr>
            </table>
            
            <!-- المجموع بالدينار العراقي -->
            <div style="border: 1px solid #ddd; margin-bottom: 20px;">
                <div style="padding: 8px; text-align: center; border-bottom: 1px solid #ddd; background-color: #f9a825; font-weight: bold;">
                    المجموع بالدينار العراقي
                </div>
                <div style="padding: 15px; text-align: center; font-size: 24px; font-weight: bold;">
                    <?php echo e($receipt_details->total_in_words ?? '١٩٢,٠٠٠.٠٠', false); ?>

                </div>
            </div>
            
            <!-- ملخص الضريبة -->
            <?php if(empty($receipt_details->hide_price) && !empty($receipt_details->tax_summary_label)): ?>
                <?php if(!empty($receipt_details->taxes)): ?>
                    <table style="width: 100%; border-collapse: collapse; margin-bottom: 15px; border: 1px solid #ddd;">
                        <tr>
                            <th colspan="2" style="padding: 8px; text-align: center; border-bottom: 1px solid #ddd; background-color: #f9a825;"><?php echo e($receipt_details->tax_summary_label, false); ?></th>
                        </tr>
                        <?php $__currentLoopData = $receipt_details->taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td style="padding: 5px; text-align: center; border-right: 1px solid #ddd;"><b><?php echo e($key, false); ?></b></td>
                                <td style="padding: 5px; text-align: center;"><?php echo e($val, false); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </table>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>

    <div style="clear: both;"></div>

    <!-- ملاحظات إضافية -->
    <?php if(!empty($receipt_details->additional_notes)): ?>
        <div class="row" style="margin-top: 15px;">
            <div class="col-xs-12">
                <p style="margin-bottom: 15px;"><?php echo nl2br($receipt_details->additional_notes); ?></p>
            </div>
        </div>
    <?php endif; ?>

    <!-- معلومات الاتصال والصفحة -->
    <div style="margin-top: 30px; border-top: 3px solid #f9a825; padding-top: 10px;">
        <div style="float: left; width: 10%;">
            <div style="padding: 5px; text-align: center; border: 1px solid #ddd; background-color: #f9a825; font-weight: bold; display: inline-block;">
                1/1
            </div>
        </div>
        <div style="float: right; width: 90%; text-align: right;">
            <p>بغداد - الشورجة - مجاور خان حميد النجــــار / 07711386000-07700004472</p>
            <p>بغداد - الصرافية - مجاور جامع عادلة خاتون / 07714440002-07700004462</p>
        </div>
    </div>
</div><?php /**PATH C:\xampp\htdocs\combossas\resources\views/sale_pos/receipts/classic.blade.php ENDPATH**/ ?>