<?php $__env->startSection('title', __('SAP Integration')); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1><?php echo app('translator')->get('SAP B1 Integration'); ?></h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
                <div class="row">
                    <div class="col-md-6">
                        <div class="box box-solid">
                            <div class="box-header with-border">
                                <h3 class="box-title"><?php echo app('translator')->get('Products Synchronization'); ?></h3>
                            </div>
                            <div class="box-body">
                                <form action="<?php echo e(route('sap.sync.products'), false); ?>" method="POST" id="sync-products-form">
                                    <?php echo csrf_field(); ?>
                                    <div class="form-group">
                                        <label>
                                            <input type="checkbox" name="full_sync" value="1"> 
                                            <?php echo app('translator')->get('Perform full sync (may take longer)'); ?>
                                        </label>
                                    </div>
                                    <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Sync Products from SAP'); ?></button>
                                </form>
                                <div class="sync-status" id="products-sync-status" style="display: none;">
                                    <hr>
                                    <div class="alert alert-info sync-message">
                                        <i class="fa fa-spinner fa-spin"></i> <?php echo app('translator')->get('Syncing products...'); ?>
                                    </div>
                                    <div class="sync-results" style="display: none;">
                                        <h4><?php echo app('translator')->get('Results'); ?>:</h4>
                                        <table class="table table-bordered table-striped">
                                            <tr>
                                                <th><?php echo app('translator')->get('Total Items'); ?></th>
                                                <td class="total-count">0</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo app('translator')->get('Created'); ?></th>
                                                <td class="created-count">0</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo app('translator')->get('Updated'); ?></th>
                                                <td class="updated-count">0</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo app('translator')->get('Skipped'); ?></th>
                                                <td class="skipped-count">0</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo app('translator')->get('Failed'); ?></th>
                                                <td class="failed-count">0</td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="box box-solid">
                            <div class="box-header with-border">
                                <h3 class="box-title"><?php echo app('translator')->get('Contacts Synchronization'); ?></h3>
                            </div>
                            <div class="box-body">
                                <form action="<?php echo e(route('sap.sync.contacts'), false); ?>" method="POST" id="sync-contacts-form">
                                    <?php echo csrf_field(); ?>
                                    <div class="form-group">
                                        <label>
                                            <input type="checkbox" name="full_sync" value="1"> 
                                            <?php echo app('translator')->get('Perform full sync (may take longer)'); ?>
                                        </label>
                                    </div>
                                    <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Sync Contacts from SAP'); ?></button>
                                </form>
                                <div class="sync-status" id="contacts-sync-status" style="display: none;">
                                    <hr>
                                    <div class="alert alert-info sync-message">
                                        <i class="fa fa-spinner fa-spin"></i> <?php echo app('translator')->get('Syncing contacts...'); ?>
                                    </div>
                                    <div class="sync-results" style="display: none;">
                                        <h4><?php echo app('translator')->get('Results'); ?>:</h4>
                                        <table class="table table-bordered table-striped">
                                            <tr>
                                                <th><?php echo app('translator')->get('Total Contacts'); ?></th>
                                                <td class="total-count">0</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo app('translator')->get('Created'); ?></th>
                                                <td class="created-count">0</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo app('translator')->get('Updated'); ?></th>
                                                <td class="updated-count">0</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo app('translator')->get('Skipped'); ?></th>
                                                <td class="skipped-count">0</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo app('translator')->get('Failed'); ?></th>
                                                <td class="failed-count">0</td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="box box-solid">
                            <div class="box-header with-border">
                                <h3 class="box-title"><?php echo app('translator')->get('Warehouses Synchronization'); ?></h3>
                            </div>
                            <div class="box-body">
                                <form action="<?php echo e(route('sap.sync.warehouses'), false); ?>" method="POST" id="sync-warehouses-form">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Sync Warehouses from SAP'); ?></button>
                                </form>
                                <div class="sync-status" id="warehouses-sync-status" style="display: none;">
                                    <hr>
                                    <div class="alert alert-info sync-message">
                                        <i class="fa fa-spinner fa-spin"></i> <?php echo app('translator')->get('Syncing warehouses...'); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="box box-solid">
                            <div class="box-header with-border">
                                <h3 class="box-title"><?php echo app('translator')->get('UoM Groups Synchronization'); ?></h3>
                            </div>
                            <div class="box-body">
                                <form action="<?php echo e(route('sap.sync.uom-groups'), false); ?>" method="POST" id="sync-uom-groups-form">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Sync UoM Groups from SAP'); ?></button>
                                </form>
                                <div class="sync-status" id="uom-groups-sync-status" style="display: none;">
                                    <hr>
                                    <div class="alert alert-info sync-message">
                                        <i class="fa fa-spinner fa-spin"></i> <?php echo app('translator')->get('Syncing UoM groups...'); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php echo $__env->renderComponent(); ?>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6">
            <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => __('Warehouse Mappings')]); ?>
                <table class="table table-bordered table-striped" id="warehouse-mappings-table">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('SAP Warehouse Code'); ?></th>
                            <th><?php echo app('translator')->get('SAP Warehouse Name'); ?></th>
                            <th><?php echo app('translator')->get('POS Business Location'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $warehouseMappings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mapping): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($mapping->warehouse_code, false); ?></td>
                            <td><?php echo e($mapping->warehouse_name, false); ?></td>
                            <td>
                                <select class="form-control location-select" name="mappings[<?php echo e($mapping->warehouse_code, false); ?>]" data-warehouse-code="<?php echo e($mapping->warehouse_code, false); ?>">
                                    <option value=""><?php echo app('translator')->get('None'); ?></option>
                                    <?php $__currentLoopData = $businessLocations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($id, false); ?>" <?php echo e($mapping->location_id == $id ? 'selected' : '', false); ?>><?php echo e($name, false); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <button class="btn btn-primary" id="save-warehouse-mappings"><?php echo app('translator')->get('Save Warehouse Mappings'); ?></button>
            <?php echo $__env->renderComponent(); ?>
        </div>
        
        <div class="col-md-6">
            <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => __('UoM Mappings')]); ?>
                <table class="table table-bordered table-striped" id="uom-mappings-table">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('SAP UoM Code'); ?></th>
                            <th><?php echo app('translator')->get('SAP UoM Name'); ?></th>
                            <th><?php echo app('translator')->get('POS Unit'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $uomMappings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mapping): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($mapping->uom_code, false); ?></td>
                            <td><?php echo e($mapping->uom_name, false); ?></td>
                            <td>
                                <select class="form-control unit-select" name="mappings[<?php echo e($mapping->id, false); ?>]" data-uom-id="<?php echo e($mapping->id, false); ?>">
                                    <option value=""><?php echo app('translator')->get('None'); ?></option>
                                    <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($id, false); ?>" <?php echo e($mapping->unit_id == $id ? 'selected' : '', false); ?>><?php echo e($name, false); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <button class="btn btn-primary" id="save-uom-mappings"><?php echo app('translator')->get('Save UoM Mappings'); ?></button>
            <?php echo $__env->renderComponent(); ?>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script>
    $(document).ready(function() {
        // Products sync
        $('#sync-products-form').submit(function(e) {
            e.preventDefault();
            let form = $(this);
            let url = form.attr('action');
            let fullSync = form.find('input[name="full_sync"]').is(':checked') ? 1 : 0;
            
            $('#products-sync-status').show();
            $('.sync-results', '#products-sync-status').hide();
            
            $.ajax({
                url: url,
                type: 'POST',
                data: { full_sync: fullSync, _token: '<?php echo e(csrf_token(), false); ?>' },
                success: function(response) {
                    if (response.success) {
                        $('.sync-message', '#products-sync-status').removeClass('alert-info alert-danger').addClass('alert-success').html('<i class="fa fa-check"></i> ' + response.message);
                        $('.sync-results', '#products-sync-status').show();
                        $('.total-count', '#products-sync-status').text(response.data.total);
                        $('.created-count', '#products-sync-status').text(response.data.created);
                        $('.updated-count', '#products-sync-status').text(response.data.updated);
                        $('.skipped-count', '#products-sync-status').text(response.data.skipped);
                        $('.failed-count', '#products-sync-status').text(response.data.failed);
                    } else {
                        $('.sync-message', '#products-sync-status').removeClass('alert-info alert-success').addClass('alert-danger').text(response.message);
                    }
                },
                error: function(xhr) {
                    $('.sync-message', '#products-sync-status').removeClass('alert-info alert-success').addClass('alert-danger').text('Error: ' + (xhr.responseJSON ? xhr.responseJSON.message : 'Unknown error'));
                }
            });
        });
        
        // Contacts sync
        $('#sync-contacts-form').submit(function(e) {
            e.preventDefault();
            let form = $(this);
            let url = form.attr('action');
            let fullSync = form.find('input[name="full_sync"]').is(':checked') ? 1 : 0;
            
            $('#contacts-sync-status').show();
            $('.sync-results', '#contacts-sync-status').hide();
            
            $.ajax({
                url: url,
                type: 'POST',
                data: { full_sync: fullSync, _token: '<?php echo e(csrf_token(), false); ?>' },
                success: function(response) {
                    if (response.success) {
                        $('.sync-message', '#contacts-sync-status').removeClass('alert-info alert-danger').addClass('alert-success').html('<i class="fa fa-check"></i> ' + response.message);
                        $('.sync-results', '#contacts-sync-status').show();
                        $('.total-count', '#contacts-sync-status').text(response.data.total);
                        $('.created-count', '#contacts-sync-status').text(response.data.created);
                        $('.updated-count', '#contacts-sync-status').text(response.data.updated);
                        $('.skipped-count', '#contacts-sync-status').text(response.data.skipped);
                        $('.failed-count', '#contacts-sync-status').text(response.data.failed);
                    } else {
                        $('.sync-message', '#contacts-sync-status').removeClass('alert-info alert-success').addClass('alert-danger').text(response.message);
                    }
                },
                error: function(xhr) {
                    $('.sync-message', '#contacts-sync-status').removeClass('alert-info alert-success').addClass('alert-danger').text('Error: ' + (xhr.responseJSON ? xhr.responseJSON.message : 'Unknown error'));
                }
            });
        });
        
        // Warehouses sync
        $('#sync-warehouses-form').submit(function(e) {
            e.preventDefault();
            let form = $(this);
            let url = form.attr('action');
            
            $('#warehouses-sync-status').show();
            
            $.ajax({
                url: url,
                type: 'POST',
                data: { _token: '<?php echo e(csrf_token(), false); ?>' },
                success: function(response) {
                    if (response.success) {
                        $('.sync-message', '#warehouses-sync-status').removeClass('alert-info alert-danger').addClass('alert-success').html('<i class="fa fa-check"></i> ' + response.message);
                        // Reload page to show new warehouse mappings
                        setTimeout(function() {
                            window.location.reload();
                        }, 2000);
                    } else {
                        $('.sync-message', '#warehouses-sync-status').removeClass('alert-info alert-success').addClass('alert-danger').text(response.message);
                    }
                },
                error: function(xhr) {
                    $('.sync-message', '#warehouses-sync-status').removeClass('alert-info alert-success').addClass('alert-danger').text('Error: ' + (xhr.responseJSON ? xhr.responseJSON.message : 'Unknown error'));
                }
            });
        });
        
        // UoM Groups sync
        $('#sync-uom-groups-form').submit(function(e) {
            e.preventDefault();
            let form = $(this);
            let url = form.attr('action');
            
            $('#uom-groups-sync-status').show();
            
            $.ajax({
                url: url,
                type: 'POST',
                data: { _token: '<?php echo e(csrf_token(), false); ?>' },
                success: function(response) {
                    if (response.success) {
                        $('.sync-message', '#uom-groups-sync-status').removeClass('alert-info alert-danger').addClass('alert-success').html('<i class="fa fa-check"></i> ' + response.message);
                        // Reload page to show new UoM mappings
                        setTimeout(function() {
                            window.location.reload();
                        }, 2000);
                    } else {
                        $('.sync-message', '#uom-groups-sync-status').removeClass('alert-info alert-success').addClass('alert-danger').text(response.message);
                    }
                },
                error: function(xhr) {
                    $('.sync-message', '#uom-groups-sync-status').removeClass('alert-info alert-success').addClass('alert-danger').text('Error: ' + (xhr.responseJSON ? xhr.responseJSON.message : 'Unknown error'));
                }
            });
        });
        
        // Save warehouse mappings
        $('#save-warehouse-mappings').click(function() {
            let mappings = {};
            
            $('.location-select').each(function() {
                let warehouseCode = $(this).data('warehouse-code');
                let locationId = $(this).val();
                mappings[warehouseCode] = locationId;
            });
            
            $.ajax({
                url: '<?php echo e(route("sap.map.warehouses"), false); ?>',
                type: 'POST',
                data: { 
                    mappings: mappings, 
                    _token: '<?php echo e(csrf_token(), false); ?>' 
                },
                success: function(response) {
                    if (response.success) {
                        toastr.success(response.message);
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function(xhr) {
                    toastr.error('Error: ' + (xhr.responseJSON ? xhr.responseJSON.message : 'Unknown error'));
                }
            });
        });
        
        // Save UoM mappings
        $('#save-uom-mappings').click(function() {
            let mappings = {};
            
            $('.unit-select').each(function() {
                let uomId = $(this).data('uom-id');
                let unitId = $(this).val();
                mappings[uomId] = unitId;
            });
            
            $.ajax({
                url: '<?php echo e(route("sap.map.uoms"), false); ?>',
                type: 'POST',
                data: { 
                    mappings: mappings, 
                    _token: '<?php echo e(csrf_token(), false); ?>' 
                },
                success: function(response) {
                    if (response.success) {
                        toastr.success(response.message);
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function(xhr) {
                    toastr.error('Error: ' + (xhr.responseJSON ? xhr.responseJSON.message : 'Unknown error'));
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nhiq/combossas/resources/views/sap/dashboard.blade.php ENDPATH**/ ?>