<div class="row">
	<div class="col-md-12">
		<p><strong><?php echo app('translator')->get('sale.invoice_no'); ?>:</strong> <?php echo e($transaction->invoice_no, false); ?></p>
	</div>
	<div class="col-md-4">
		<div class="form-group" style="width: 100% !important">
			<div class="input-group">
				<span class="input-group-addon">
					<i class="fa fa-user"></i>
				</span>
				<input type="hidden" id="default_customer_id" 
				value="<?php echo e($transaction->contact->id, false); ?>" >
				<input type="hidden" id="default_customer_name" 
				value="<?php echo e($transaction->contact->name, false); ?>" >
				<input type="hidden" id="default_customer_balance" 
				value="<?php echo e($transaction->contact->balance, false); ?>" >
				<?php echo Form::select('contact_id', 
					[], null, ['class' => 'form-control mousetrap', 'id' => 'customer_id', 'placeholder' => 'Enter Customer name / phone', 'required', 'style' => 'width: 100%;']); ?>

				<span class="input-group-btn">
					<button type="button" class="btn btn-default bg-white btn-flat add_new_customer" data-name=""  <?php if(!auth()->user()->can('customer.create')): ?> disabled <?php endif; ?>><i class="fa fa-plus-circle text-primary fa-lg"></i></button>
				</span>
			</div>
			<small class="text-danger <?php if(empty($customer_due)): ?> hide <?php endif; ?> contact_due_text"><strong><?php echo app('translator')->get('account.customer_due'); ?>:</strong> <span><?php echo e($customer_due ?? '', false); ?></span></small>
		</div>
	</div>
	<div class="col-md-8">
		<div class="form-group">
			<div class="input-group">
				<div class="input-group-btn">
					<button type="button" class="btn btn-default bg-white btn-flat" data-toggle="modal" data-target="#configure_search_modal" title="<?php echo e(__('lang_v1.configure_product_search'), false); ?>"><i class="fas fa-search-plus"></i></button>
				</div>
                
				<?php echo Form::text('search_product', null, ['class' => 'form-control', 'id' => 'search_product', 'placeholder' => __('lang_v1.search_product_placeholder'),
				'autofocus' => true,
				]); ?>

				<span class="input-group-btn">

					<!-- Show button for weighing scale modal -->
					<?php if(isset($pos_settings['enable_weighing_scale']) && $pos_settings['enable_weighing_scale'] == 1): ?>
						<button type="button" class="btn btn-default bg-white btn-flat" id="weighing_scale_btn" data-toggle="modal" data-target="#weighing_scale_modal" 
						title="<?php echo app('translator')->get('lang_v1.weighing_scale'); ?>"><i class="fa fa-digital-tachograph text-primary fa-lg"></i></button>
					<?php endif; ?>

					<button type="button" class="btn btn-default bg-white btn-flat pos_add_quick_product" data-href="<?php echo e(action([\App\Http\Controllers\ProductController::class, 'quickAdd']), false); ?>" data-container=".quick_add_product_modal"><i class="fa fa-plus-circle text-primary fa-lg"></i></button>
				</span>
			</div>
		</div>
	</div>
</div>
<div class="row">
	<?php if(!empty($pos_settings['show_invoice_layout'])): ?>
	<div class="col-md-4">
		<div class="form-group">
		<?php echo Form::select('invoice_layout_id', 
					$invoice_layouts, $transaction->location->invoice_layout_id, ['class' => 'form-control select2', 'placeholder' => __('lang_v1.select_invoice_layout'), 'id' => 'invoice_layout_id']); ?>

		</div>
	</div>
	<?php endif; ?>
	<input type="hidden" name="pay_term_number" id="pay_term_number" value="<?php echo e($transaction->pay_term_number, false); ?>">
	<input type="hidden" name="pay_term_type" id="pay_term_type" value="<?php echo e($transaction->pay_term_type, false); ?>">
	
	<?php if(!empty($commission_agent)): ?>
		<?php
			$is_commission_agent_required = !empty($pos_settings['is_commission_agent_required']);
		?>
		<div class="col-sm-4">
			<div class="form-group">
			<?php echo Form::select('commission_agent', 
						$commission_agent, $transaction->commission_agent, ['class' => 'form-control select2', 'placeholder' => __('lang_v1.commission_agent'), 'id' => 'commission_agent', 'required' => $is_commission_agent_required]); ?>

			</div>
		</div>
		<?php endif; ?>
	<?php if(!empty($pos_settings['enable_transaction_date'])): ?>
		<div class="col-md-4 col-sm-6">
			<div class="form-group">
				<div class="input-group">
					<span class="input-group-addon">
						<i class="fa fa-calendar"></i>
					</span>
					<?php echo Form::text('transaction_date', \Carbon::createFromTimestamp(strtotime($transaction->transaction_date))->format(session('business.date_format') . ' ' . 'H:i'), ['class' => 'form-control', 'readonly', 'required', 'id' => 'transaction_date']); ?>

				</div>
			</div>
		</div>
	<?php endif; ?>
	<?php if(config('constants.enable_sell_in_diff_currency') == true): ?>
		<div class="col-md-4 col-sm-6">
			<div class="form-group">
				<div class="input-group">
					<span class="input-group-addon">
						<i class="fas fa-exchange-alt"></i>
					</span>
					<?php echo Form::text('exchange_rate', number_format($transaction->exchange_rate, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), ['class' => 'form-control input-sm input_number', 'placeholder' => __('lang_v1.currency_exchange_rate'), 'id' => 'exchange_rate']); ?>

				</div>
			</div>
		</div>
	<?php endif; ?>
	<?php if(!empty($transaction->selling_price_group_id)): ?>
		<div class="col-md-4 col-sm-6">
			<div class="form-group">
				<div class="input-group">
					<span class="input-group-addon">
						<i class="fas fa-money-bill-alt"></i>
					</span>
					<?php echo Form::hidden('price_group', $transaction->selling_price_group_id, ['id' => 'price_group']); ?>

					<?php echo Form::text('price_group_text', $transaction->price_group->name, ['class' => 'form-control', 'readonly']); ?>

					<span class="input-group-addon">
					<?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('lang_v1.price_group_help_text') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
				</span> 
				</div>
			</div>
		</div>
	<?php endif; ?>

	<?php if(in_array('types_of_service', $enabled_modules) && !empty($transaction->types_of_service)): ?>
		<div class="col-md-4 col-sm-6">
			<div class="form-group">
				<div class="input-group">
					<span class="input-group-addon">
						<i class="fas fa-external-link-square-alt text-primary service_modal_btn"></i>
					</span>
					<?php echo Form::text('types_of_service_text', $transaction->types_of_service->name, ['class' => 'form-control', 'readonly']); ?>


					<?php echo Form::hidden('types_of_service_id', $transaction->types_of_service_id, ['id' => 'types_of_service_id']); ?>

					<span class="input-group-addon">
						<?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('lang_v1.types_of_service_help') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
					</span> 
				</div>
				<small><p class="help-block <?php if(empty($transaction->selling_price_group_id)): ?> hide <?php endif; ?>" id="price_group_text"><?php echo app('translator')->get('lang_v1.price_group'); ?>: <span><?php if(!empty($transaction->selling_price_group_id)): ?><?php echo e($transaction->price_group->name, false); ?><?php endif; ?></span></p></small>
			</div>
		</div>
		<div class="modal fade types_of_service_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
			<?php if(!empty($transaction->types_of_service)): ?>
				<?php echo $__env->make('types_of_service.pos_form_modal', ['types_of_service' => $transaction->types_of_service], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
			<?php endif; ?>
		</div>
	<?php endif; ?>
	<?php if($transaction->status == 'draft' && !empty($pos_settings['show_invoice_scheme'])): ?>
		<div class="col-sm-3">
			<div class="form-group">
				<?php echo Form::select('invoice_scheme_id', $invoice_schemes, $default_invoice_schemes->id, ['class' => 'form-control', 'placeholder' => __('lang_v1.select_invoice_scheme')]); ?>

			</div>
		</div>
	<?php endif; ?>
	<!-- Call restaurant module if defined -->
    <?php if(in_array('tables' ,$enabled_modules) || in_array('service_staff' ,$enabled_modules)): ?>
    	<span id="restaurant_module_span" 
    		data-transaction_id="<?php echo e($transaction->id, false); ?>">
      		<div class="col-md-3"></div>
    	</span>
    <?php endif; ?>
	<?php if(in_array('kitchen' ,$enabled_modules)): ?>
		<div class="col-md-3">
			<div class="form-group">
				<div class="checkbox">
				<label>
						<?php echo Form::checkbox('is_kitchen_order', 1, $transaction->is_kitchen_order, ['class' => 'input-icheck status', 'id' => 'is_kitchen_order']); ?> <?php echo e(__('lang_v1.kitchen_order'), false); ?>

				</label>
				</div>
			</div>
		</div>
    <?php endif; ?>
    <?php if(in_array('subscription', $enabled_modules)): ?>
		<div class="col-md-4 col-sm-6">
			<label>
              <?php echo Form::checkbox('is_recurring', 1, $transaction->is_recurring, ['class' => 'input-icheck', 'id' => 'is_recurring']); ?> <?php echo app('translator')->get('lang_v1.subscribe'); ?>?
            </label><button type="button" data-toggle="modal" data-target="#recurringInvoiceModal" class="btn btn-link"><i class="fa fa-external-link-square-alt"></i></button><?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('lang_v1.recurring_invoice_help') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
		</div>
	<?php endif; ?>
</div>
<!-- include module fields -->
<?php if(!empty($pos_module_data)): ?>
    <?php $__currentLoopData = $pos_module_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if(!empty($value['view_path'])): ?>
            <?php if ($__env->exists($value['view_path'], ['view_data' => $value['view_data']])) echo $__env->make($value['view_path'], ['view_data' => $value['view_data']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
<div class="row">
	<div class="col-sm-12 pos_product_div">
		<input type="hidden" name="sell_price_tax" id="sell_price_tax" value="<?php echo e($business_details->sell_price_tax, false); ?>">

		<!-- Keeps count of product rows -->
		<input type="hidden" id="product_row_count" 
			value="<?php echo e(count($sell_details), false); ?>">
		<?php
			$hide_tax = '';
			if( session()->get('business.enable_inline_tax') == 0){
				$hide_tax = 'hide';
			}
		?>
		
		<div class="table-responsive">
			<table class="table table-condensed table-bordered table-striped material-pos-table" id="pos_table">
				<thead>
					<tr>
						<th width="3%" class="text-center">#</th>
						<th width="" class="text-center">Product</th>
						<th width="8%" class="text-center">Quantity</th>
						<th width="8%" class="text-center">Unit</th>
						<th width="8%" class="text-center">Price (USD)</th>
						<th width="8%" class="text-center">Price (IQD)</th>
						<th width="6%" class="text-center">Discount %</th>
						<th width="8%" class="text-center <?php echo e($hide_tax, false); ?>">Price inc. tax</th>
						<th width="8%" class="text-center">Subtotal</th>
						<th width="10%" class="text-center">Warehouse</th>
						<th width="8%" class="text-center">Stock Info</th>
						<?php if(!empty($pos_settings['inline_service_staff'])): ?>
							<th width="10%" class="text-center">Service Staff</th>
						<?php endif; ?>
						<th width="2%" class="text-center">Actions</th>
					</tr>
				</thead>
				<tbody>
					<?php $__currentLoopData = $sell_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sell_line): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<?php echo $__env->make('sale_pos.product_row', 
							['product' => $sell_line, 
							'row_count' => $loop->index, 
							'tax_dropdown' => $taxes, 
							'sub_units' => !empty($sell_line->unit_details) ? $sell_line->unit_details : [],
							'action' => 'edit'
						], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</tbody>
			</table>
		</div>
	</div>
</div>

<!-- CSS Styles -->
<style>
/* Material Design Inspired POS Table */
.material-pos-table {
    width: 100%;
    table-layout: fixed;
    margin-bottom: 0;
    border-collapse: separate;
    border-spacing: 0;
    box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    border-radius: 8px;
    overflow: hidden;
}

/* Header Styling */
.material-pos-table thead th {
    background: linear-gradient(135deg, #556270 0%, #4a5968 100%);
    color: #ffffff;
    padding: 8px 4px;
    font-size: 12px;
    font-weight: 500;
    text-align: center;
    white-space: nowrap;
    vertical-align: middle;
    border: none;
    height: 32px;
    line-height: 1.2;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

/* Body Cell Styling */
.material-pos-table tbody td {
    padding: 4px 3px;
    font-size: 12px;
    vertical-align: middle;
    border-bottom: 1px solid #e0e0e0;
    height: 32px;
    background-color: #ffffff;
    color: #333333;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    line-height: 1.2;
}

/* Zebra Striping */
.material-pos-table tbody tr:nth-child(even) td {
    background-color: #f8f9fa;
}

/* Hover Effects */
.material-pos-table tbody tr:hover td {
    background-color: #e8f4f8 !important;
    transition: background-color 0.2s ease;
}

/* Input Field Styling */
.material-pos-table input.form-control,
.material-pos-table select.form-control {
    padding: 2px 4px;
    height: 24px;
    font-size: 12px;
    border: 1px solid #ddd;
    border-radius: 4px;
    width: 100%;
    background-color: #ffffff;
    transition: border-color 0.2s ease;
}

.material-pos-table input.form-control:focus,
.material-pos-table select.form-control:focus {
    border-color: #556270;
    box-shadow: 0 0 0 2px rgba(85, 98, 112, 0.1);
    outline: none;
}

/* Unit Search Input */
.unit-search-input {
    width: 100%;
    padding: 2px 4px;
    border: 1px solid #ddd;
    border-radius: 4px;
    font-size: 12px;
    background-color: #ffffff;
}

/* Numeric Input Fields */
.material-pos-table input.pos_quantity,
.material-pos-table input.pos_unit_price_usd,
.material-pos-table input.pos_unit_price_iqd,
.material-pos-table input.discount_percent,
.material-pos-table input.pos_unit_price_inc_tax {
    text-align: center;
    background-color: #f9fafb;
}

/* Warehouse Selector */
.warehouse-selector {
    width: 100%;
    height: 24px;
    padding: 0 4px;
    font-size: 12px;
    border: 1px solid #ddd;
    border-radius: 4px;
}

/* Stock Info Styling */
.stock-info-cell {
    font-size: 11px;
    text-align: center;
    font-weight: 500;
}

.stock-available {
    color: #28a745;
}

.stock-warning {
    color: #ffc107;
    font-weight: 600;
}

.stock-error {
    color: #dc3545;
    font-weight: 600;
}

/* Action Button */
.pos_remove_row {
    color: #dc3545;
    cursor: pointer;
    font-size: 16px;
    padding: 2px;
    border-radius: 4px;
    transition: all 0.2s ease;
}

.pos_remove_row:hover {
    color: #ffffff;
    background-color: #dc3545;
    transform: scale(1.1);
}

/* Line Total Styling */
.pos_line_total_text {
    font-weight: 600;
    font-size: 12px;
    color: #2c3e50;
}

/* Adjust column widths for edit view */
.material-pos-table th:nth-child(1), .material-pos-table td:nth-child(1) { width: 3%; }
.material-pos-table th:nth-child(2), .material-pos-table td:nth-child(2) { width: 20%; }
.material-pos-table th:nth-child(3), .material-pos-table td:nth-child(3) { width: 7%; }
.material-pos-table th:nth-child(4), .material-pos-table td:nth-child(4) { width: 7%; }
.material-pos-table th:nth-child(5), .material-pos-table td:nth-child(5) { width: 7%; }
.material-pos-table th:nth-child(6), .material-pos-table td:nth-child(6) { width: 7%; }
.material-pos-table th:nth-child(7), .material-pos-table td:nth-child(7) { width: 6%; }
.material-pos-table th:nth-child(8), .material-pos-table td:nth-child(8) { width: 7%; }
.material-pos-table th:nth-child(9), .material-pos-table td:nth-child(9) { width: 7%; }
.material-pos-table th:nth-child(10), .material-pos-table td:nth-child(10) { width: 9%; }
.material-pos-table th:nth-child(11), .material-pos-table td:nth-child(11) { width: 7%; }

/* If service staff column is enabled */
<?php if(!empty($pos_settings['inline_service_staff'])): ?>
.material-pos-table th:nth-child(12), .material-pos-table td:nth-child(12) { width: 9%; }
.material-pos-table th:nth-child(13), .material-pos-table td:nth-child(13) { width: 2%; }
<?php else: ?>
.material-pos-table th:nth-child(12), .material-pos-table td:nth-child(12) { width: 2%; }
<?php endif; ?>

/* Product Name Cell */
.material-pos-table .product_name {
    font-weight: 500;
    color: #2c3e50;
}

/* Serial Number */
.material-pos-table .serial_no {
    font-weight: 600;
    color: #556270;
}

/* Select2 Customization */
.material-pos-table .select2-container .select2-selection--single {
    height: 24px;
    line-height: 22px;
    border: 1px solid #ddd;
    border-radius: 4px;
}

.material-pos-table .select2-container--default .select2-selection--single .select2-selection__rendered {
    padding-left: 4px;
    padding-right: 20px;
    line-height: 22px;
    color: #333;
}

.material-pos-table .select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 22px;
    right: 2px;
}

/* Responsive Table Container */
.table-responsive {
    overflow-x: auto;
    margin-bottom: 0;
    border-radius: 8px;
    box-shadow: 0 0 10px rgba(0,0,0,0.05);
}

/* Badge Style for SKU */
.sku-badge {
    display: inline-block;
    padding: 2px 6px;
    background-color: #e9ecef;
    color: #495057;
    border-radius: 4px;
    font-size: 10px;
    font-weight: 500;
}

/* Smooth scrolling */
.pos_product_div {
    scrollbar-width: thin;
    scrollbar-color: #888 #f1f1f1;
}

.pos_product_div::-webkit-scrollbar {
    height: 8px;
}

.pos_product_div::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 4px;
}

.pos_product_div::-webkit-scrollbar-thumb {
    background: #888;
    border-radius: 4px;
}

.pos_product_div::-webkit-scrollbar-thumb:hover {
    background: #555;
}

/* Animation for new rows */
@keyframes fadeIn {
    from { opacity: 0; transform: translateY(-10px); }
    to { opacity: 1; transform: translateY(0); }
}

.material-pos-table tbody tr {
    animation: fadeIn 0.3s ease-out;
}

/* Hide tax column if inline tax is disabled */
.material-pos-table th.hide,
.material-pos-table td.hide {
    display: none;
}

/* Input group buttons for quantity */
.material-pos-table .input-number {
    position: relative;
    display: flex;
    align-items: center;
}

.material-pos-table .input-number .input-group-btn {
    display: flex;
}

.material-pos-table .input-number .btn {
    padding: 0 6px;
    height: 24px;
    min-width: 24px;
    border: 1px solid #ddd;
    background: #f8f9fa;
    display: flex;
    align-items: center;
    justify-content: center;
}

.material-pos-table .input-number .btn:hover {
    background: #e9ecef;
}

.material-pos-table .input-number .pos_quantity {
    text-align: center;
    margin: 0 2px;
    flex: 1;
}

/* Additional responsive styles */
@media (max-width: 1200px) {
    .material-pos-table {
        font-size: 11px;
    }
    
    .material-pos-table thead th {
        font-size: 11px;
        padding: 6px 2px;
    }
    
    .material-pos-table tbody td {
        padding: 3px 2px;
        font-size: 11px;
    }
    
    .material-pos-table input.form-control,
    .material-pos-table select.form-control {
        font-size: 11px;
        height: 22px;
    }
}
</style><?php /**PATH C:\xampp\htdocs\combossas\resources\views/sale_pos/partials/pos_form_edit.blade.php ENDPATH**/ ?>