<?php
    $is_mobile = isMobile();
?>
<div class="row">
    <div class="pos-form-actions" style="border-radius: 0.75rem 0.75rem 0 0; box-shadow: rgba(17, 17, 26, 0.1) 0px 0px 16px; background-color: white; cursor: pointer;">
        <div style="display: flex; align-items: center; justify-content: space-between; padding: 1rem; overflow-x: auto; width: 100%; gap: 0.5rem;">
            
            <!-- Total Payable Section (Left) -->
            <div class="pos-total" style="display: flex; align-items: center; gap: 0.5rem; flex-shrink: 0;">
                <div style="color: black; font-weight: bold; font-size: 0.875rem;">
                    <?php echo app('translator')->get('sale.total_payable'); ?>:
                </div>
                <input type="hidden" name="final_total" id="final_total_input" value="0.00">
                <span id="total_payable" style="color: #1e3a1e; font-weight: bold; font-size: 1rem;" class="number">0.00</span>
            </div>

            <!-- All Buttons Container (Center) -->
            <div style="display: flex; align-items: center; gap: 0.5rem; flex-wrap: nowrap;">
                <?php if(!Gate::check('disable_pay_checkout') || auth()->user()->can('superadmin') || auth()->user()->can('admin')): ?>
                    <button type="button"
                        style="display: flex; flex-direction: row; align-items: center; justify-content: center; gap: 0.3rem; font-weight: bold; color: white; cursor: pointer; font-size: 0.75rem; background-color: #001F3E; border-radius: 0.375rem; padding: 0.5rem; min-width: 100px; height: 40px; border: none; transition: opacity 0.2s; white-space: nowrap;"
                        onmouseover="this.style.opacity='0.9'" onmouseout="this.style.opacity='1'"
                        id="pos-finalize" title="<?php echo app('translator')->get('lang_v1.tooltip_checkout_multi_pay'); ?>">
                        <i class="fas fa-money-check-alt" aria-hidden="true"></i> 
                        <?php echo app('translator')->get('lang_v1.checkout_multi_pay'); ?>
                    </button>
                <?php endif; ?>

                

                <?php if(!Gate::check('disable_express_checkout') || auth()->user()->can('superadmin') || auth()->user()->can('admin')): ?>
                    <button type="button"
                        class="tw-font-bold tw-text-white tw-cursor-pointer tw-text-xs md:tw-text-sm tw-bg-[rgb(40,183,123)] tw-p-2 tw-rounded-md tw-w-[5.5rem] tw-flex tw-flex-row tw-items-center tw-justify-center tw-gap-1 <?php if(!$is_mobile): ?>  <?php endif; ?> no-print <?php if($pos_settings['disable_express_checkout'] != 0 || !array_key_exists('cash', $payment_types)): ?> hide <?php endif; ?> pos-express-finalize <?php if($is_mobile): ?> col-xs-6 <?php endif; ?>"
                        data-pay_method="cash" title="<?php echo app('translator')->get('tooltip.express_checkout'); ?>"> <i class="fas fa-money-bill-alt"
                            aria-hidden="true"></i>Sale Order</button>
                <?php endif; ?>

                <?php if(!Gate::check('disable_draft') || auth()->user()->can('superadmin') || auth()->user()->can('admin')): ?>
                    <button type="button"
                        style="display: flex; flex-direction: row; align-items: center; justify-content: center; gap: 0.3rem; font-weight: bold; color: white; cursor: pointer; font-size: 0.75rem; background-color: #009ce4; border-radius: 0.375rem; padding: 0.5rem; min-width: 80px; height: 40px; border: none; transition: opacity 0.2s; white-space: nowrap;"
                        onmouseover="this.style.opacity='0.9'" onmouseout="this.style.opacity='1'"
                        id="pos-draft" <?php if(!empty($only_payment)): ?> disabled <?php endif; ?>>
                        <i class="fas fa-edit"></i> 
                        <?php echo app('translator')->get('sale.draft'); ?>
                    </button>
                <?php endif; ?>

                <?php if(!Gate::check('disable_quotation') || auth()->user()->can('superadmin') || auth()->user()->can('admin')): ?>
                    <button type="button"
                        style="display: flex; flex-direction: row; align-items: center; justify-content: center; gap: 0.3rem; font-weight: bold; color: white; cursor: pointer; font-size: 0.75rem; background-color: #E7A500; border-radius: 0.375rem; padding: 0.5rem; min-width: 80px; height: 40px; border: none; transition: opacity 0.2s; white-space: nowrap;"
                        onmouseover="this.style.opacity='0.9'" onmouseout="this.style.opacity='1'"
                        id="pos-quotation" <?php if(!empty($only_payment)): ?> disabled <?php endif; ?>>
                        <i class="fas fa-edit"></i> 
                        <?php echo app('translator')->get('lang_v1.quotation'); ?>
                    </button>
                <?php endif; ?>

                <?php if(!Gate::check('disable_suspend_sale') || auth()->user()->can('superadmin') || auth()->user()->can('admin')): ?>
                    <?php if(empty($pos_settings['disable_suspend'])): ?>
                        <button type="button"
                            style="display: flex; flex-direction: row; align-items: center; justify-content: center; gap: 0.3rem; font-weight: bold; color: white; cursor: pointer; font-size: 0.75rem; background-color: #EF4B51; border-radius: 0.375rem; padding: 0.5rem; min-width: 80px; height: 40px; border: none; transition: opacity 0.2s; white-space: nowrap;"
                            onmouseover="this.style.opacity='0.9'" onmouseout="this.style.opacity='1'"
                            data-pay_method="suspend" title="<?php echo app('translator')->get('lang_v1.tooltip_suspend'); ?>"
                            <?php if(!empty($only_payment)): ?> disabled <?php endif; ?>>
                            <i class="fas fa-pause" aria-hidden="true"></i>
                            <?php echo app('translator')->get('lang_v1.suspend'); ?>
                        </button>
                    <?php endif; ?>
                <?php endif; ?>

                <?php if(!Gate::check('disable_credit_sale') || auth()->user()->can('superadmin') || auth()->user()->can('admin')): ?>
                    <?php if(empty($pos_settings['disable_credit_sale_button'])): ?>
                        <input type="hidden" name="is_credit_sale" value="0" id="is_credit_sale">
                        <button type="button"
                            style="display: flex; flex-direction: row; align-items: center; justify-content: center; gap: 0.3rem; font-weight: bold; color: white; cursor: pointer; font-size: 0.75rem; background-color: #5E5CA8; border-radius: 0.375rem; padding: 0.5rem; min-width: 80px; height: 40px; border: none; transition: opacity 0.2s; white-space: nowrap;"
                            onmouseover="this.style.opacity='0.9'" onmouseout="this.style.opacity='1'"
                            data-pay_method="credit_sale" title="<?php echo app('translator')->get('lang_v1.tooltip_credit_sale'); ?>"
                            <?php if(!empty($only_payment)): ?> disabled <?php endif; ?>>
                            <i class="fas fa-check" aria-hidden="true"></i> 
                            <?php echo app('translator')->get('lang_v1.credit_sale'); ?>
                        </button>
                    <?php endif; ?>
                <?php endif; ?>
                
                <?php if(!Gate::check('disable_card') || auth()->user()->can('superadmin') || auth()->user()->can('admin')): ?>
                    <button type="button"
                        style="display: flex; flex-direction: row; align-items: center; justify-content: center; gap: 0.3rem; font-weight: bold; color: white; cursor: pointer; font-size: 0.75rem; background-color: #D61B60; border-radius: 0.375rem; padding: 0.5rem; min-width: 100px; height: 40px; border: none; transition: opacity 0.2s; white-space: nowrap;"
                        onmouseover="this.style.opacity='0.9'" onmouseout="this.style.opacity='1'"
                        data-pay_method="card" title="<?php echo app('translator')->get('lang_v1.tooltip_express_checkout_card'); ?>">
                        <i class="fas fa-credit-card" aria-hidden="true"></i> 
                        <?php echo app('translator')->get('lang_v1.express_checkout_card'); ?>
                    </button>
                <?php endif; ?>
                
                <?php if(empty($edit)): ?>
                    <button type="button" 
                        style="display: flex; flex-direction: row; align-items: center; justify-content: center; gap: 0.3rem; font-weight: bold; color: white; cursor: pointer; font-size: 0.75rem; background-color: #dc2626; border-radius: 0.375rem; padding: 0.5rem; min-width: 80px; height: 40px; border: none; transition: opacity 0.2s; white-space: nowrap;"
                        onmouseover="this.style.opacity='0.9'" onmouseout="this.style.opacity='1'"
                        id="pos-cancel">
                        <i class="fas fa-window-close"></i> 
                        <?php echo app('translator')->get('sale.cancel'); ?>
                    </button>
                <?php else: ?>
                    <button type="button" 
                        style="display: flex; flex-direction: row; align-items: center; justify-content: center; gap: 0.3rem; font-weight: bold; color: white; cursor: pointer; font-size: 0.75rem; background-color: #dc2626; border-radius: 0.375rem; padding: 0.5rem; min-width: 80px; height: 40px; border: none; transition: opacity 0.2s; white-space: nowrap;"
                        onmouseover="this.style.opacity='0.9'" onmouseout="this.style.opacity='1'"
                        id="pos-delete" <?php if(!empty($only_payment)): ?> disabled <?php endif; ?>>
                        <i class="fas fa-trash-alt"></i>
                        <?php echo app('translator')->get('messages.delete'); ?>
                    </button>
                <?php endif; ?>
            </div>

            <!-- Recent Transactions Button (Right) -->
            <?php if(!isset($pos_settings['hide_recent_trans']) || $pos_settings['hide_recent_trans'] == 0): ?>
                <button type="button"
                    style="font-weight: bold; background-color: #646EE4; border-radius: 9999px; color: white; padding: 0.5rem 1rem; height: 40px; cursor: pointer; font-size: 0.75rem; border: none; transition: opacity 0.2s; white-space: nowrap; flex-shrink: 0;"
                    onmouseover="this.style.opacity='0.9'" onmouseout="this.style.opacity='1'"
                    data-toggle="modal" data-target="#recent_transactions_modal" id="recent-transactions">
                    <i class="fas fa-clock"></i> 
                    <?php echo app('translator')->get('lang_v1.recent_transactions'); ?>
                </button>
            <?php endif; ?>
        </div>
    </div>

    
<!-- JavaScript for Sale Order Button -->
<script>
$(document).ready(function() {
    // معالج زر Sale Order المحدث
    $('.pos-sale-order-btn').click(function() {
        console.log('Sale Order button clicked');
        
        // التحقق من وجود منتجات في الجدول
        if ($('table#pos_table tbody').find('.product_row').length <= 0) {
            toastr.warning(LANG.no_products_added || 'Please add products to create sale order');
            return false;
        }

        // التحقق من نقاط المكافآت إذا كانت مفعلة
        if ($('#reward_point_enabled').length) {
            var validate_rp = isValidatRewardPoint();
            if (!validate_rp['is_valid']) {
                toastr.error(validate_rp['msg']);
                return false;
            }
        }

        // إزالة الصفوف الفارغة قبل الإرسال
        if (typeof removeEmptyRowsBeforeSubmit === 'function') {
            removeEmptyRowsBeforeSubmit();
        }

        // التحقق من صحة النموذج
        var is_valid = true;
        if (typeof isValidPosForm === 'function') {
            is_valid = isValidPosForm();
        }
        
        if (is_valid != true) {
            return false;
        }

        // تحضير البيانات مع حالة sales_order
        var data = pos_form_obj.serialize();
        data = data + '&status=sales_order'; // استخدام sales_order بدلاً من sale_order
        var url = pos_form_obj.attr('action');

        console.log('Sending sale order data:', data);

        // تعطيل أزرار العمليات
        if (typeof disable_pos_form_actions === 'function') {
            disable_pos_form_actions();
        }
        
        // إرسال البيانات
        $.ajax({
            method: 'POST',
            url: url,
            data: data,
            dataType: 'json',
            success: function(result) {
                console.log('Sale order response:', result);
                
                if (typeof enable_pos_form_actions === 'function') {
                    enable_pos_form_actions();
                }
                
                if (result.success == 1) {
                    if (typeof reset_pos_form === 'function') {
                        reset_pos_form();
                    }
                    toastr.success(result.msg || 'Sale order created successfully');

                    // طباعة الإيصال إذا كان مفعلاً
                    if (result.receipt && result.receipt.is_enabled && typeof pos_print === 'function') {
                        pos_print(result.receipt);
                    }
                } else {
                    toastr.error(result.msg || 'Error creating sale order');
                }
            },
            error: function(xhr, status, error) {
                console.error('Sale Order Error:', xhr.responseText);
                
                if (typeof enable_pos_form_actions === 'function') {
                    enable_pos_form_actions();
                }
                
                var errorMsg = 'Error occurred while processing the sale order';
                try {
                    var response = JSON.parse(xhr.responseText);
                    if (response.message) {
                        errorMsg = response.message;
                    }
                } catch(e) {
                    // استخدام الرسالة الافتراضية
                }
                
                toastr.error(errorMsg);
            }
        });
    });
});
</script>
</div>
<?php if(isset($transaction)): ?>
    <?php echo $__env->make('sale_pos.partials.edit_discount_modal', [
        'sales_discount' => $transaction->discount_amount,
        'discount_type' => $transaction->discount_type,
        'rp_redeemed' => $transaction->rp_redeemed,
        'rp_redeemed_amount' => $transaction->rp_redeemed_amount,
        'max_available' => !empty($redeem_details['points']) ? $redeem_details['points'] : 0,
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php else: ?>
    <?php echo $__env->make('sale_pos.partials.edit_discount_modal', [
        'sales_discount' => $business_details->default_sales_discount,
        'discount_type' => 'percentage',
        'rp_redeemed' => 0,
        'rp_redeemed_amount' => 0,
        'max_available' => 0,
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>

<?php if(isset($transaction)): ?>
    <?php echo $__env->make('sale_pos.partials.edit_order_tax_modal', ['selected_tax' => $transaction->tax_id], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php else: ?>
    <?php echo $__env->make('sale_pos.partials.edit_order_tax_modal', [
        'selected_tax' => $business_details->default_sales_tax,
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>

<?php echo $__env->make('sale_pos.partials.edit_shipping_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH C:\xampp\htdocs\combossas\resources\views/sale_pos/partials/pos_form_actions.blade.php ENDPATH**/ ?>